/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class ItemUpgradeBaseMachine
extends ItemUpgradeBase {
    public final int burnTimeCostPerItemSmelted = 200;

    public ItemUpgradeBaseMachine(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int fuelStored;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && (fuelStored = this.getFuelStored(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal())) > 0) {
            float f = (float)fuelStored / (float)this.getMaxFuelDeviderBasedOnFuelStored(fuelStored);
            intItem = MathHelper.func_76141_d((float)(f * 15.0f));
        }
        return intItem;
    }

    @Override
    public int getCapacityModifier(ItemStack stack) {
        int capacity = 0;
        if (this.hasEnchant(stack)) {
            capacity = this.getCapacityModifierOverEnchanted(stack) > 10 ? 10 : this.getCapacityModifierOverEnchanted(stack);
        }
        return capacity;
    }

    @Override
    public int getItemTransferRate(ItemStack stack) {
        int itemsPerSmelt = 1;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                itemsPerSmelt = 1;
                break;
            }
            case 1: {
                itemsPerSmelt = 4;
                break;
            }
            case 2: {
                itemsPerSmelt = 8;
                break;
            }
            case 3: {
                itemsPerSmelt = 12;
                break;
            }
            case 4: {
                itemsPerSmelt = 16;
                break;
            }
            case 5: {
                itemsPerSmelt = 24;
                break;
            }
            case 6: {
                itemsPerSmelt = 32;
                break;
            }
            case 7: {
                itemsPerSmelt = 40;
                break;
            }
            case 8: {
                itemsPerSmelt = 48;
                break;
            }
            case 9: {
                itemsPerSmelt = 56;
                break;
            }
            case 10: {
                itemsPerSmelt = 64;
                break;
            }
            default: {
                itemsPerSmelt = 1;
            }
        }
        return itemsPerSmelt;
    }

    @Override
    public int intOperationalSpeedModifier(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            rate = this.intOperationalSpeedModifierOverride(stack) > 10 ? 10 : this.intOperationalSpeedModifierOverride(stack);
        }
        return rate;
    }

    public int getSmeltingSpeed(ItemStack stack) {
        int smeltingSpeed = 200;
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                smeltingSpeed = 200;
                break;
            }
            case 1: {
                smeltingSpeed = 100;
                break;
            }
            case 2: {
                smeltingSpeed = 50;
                break;
            }
            case 3: {
                smeltingSpeed = 40;
                break;
            }
            case 4: {
                smeltingSpeed = 33;
                break;
            }
            case 5: {
                smeltingSpeed = 20;
                break;
            }
            case 6: {
                smeltingSpeed = 10;
                break;
            }
            case 7: {
                smeltingSpeed = 5;
                break;
            }
            case 8: {
                smeltingSpeed = 3;
                break;
            }
            case 9: {
                smeltingSpeed = 2;
                break;
            }
            case 10: {
                smeltingSpeed = 1;
                break;
            }
            default: {
                smeltingSpeed = 200;
            }
        }
        return smeltingSpeed;
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_2");
        TranslationTextComponent fivex = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_3");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_4");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_5");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_6");
        TranslationTextComponent fourtyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_7");
        TranslationTextComponent sixtyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_8");
        TranslationTextComponent onehunx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_9");
        TranslationTextComponent twohunx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_10");
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = fivex.getString();
                break;
            }
            case 4: {
                str = sixx.getString();
                break;
            }
            case 5: {
                str = tenx.getString();
                break;
            }
            case 6: {
                str = twentyx.getString();
                break;
            }
            case 7: {
                str = fourtyx.getString();
                break;
            }
            case 8: {
                str = sixtyx.getString();
                break;
            }
            case 9: {
                str = onehunx.getString();
                break;
            }
            case 10: {
                str = twohunx.getString();
                break;
            }
            default: {
                str = normal.getString();
            }
        }
        return str;
    }

    public void setFuelStored(ItemStack stack, int fuel) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("fuel", fuel);
        stack.func_77982_d(compound);
    }

    public boolean hasFuel(ItemStack stack) {
        return this.getFuelStored(stack) > 0;
    }

    public int getFuelStored(ItemStack stack) {
        int storedFuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedFuel = getCompound.func_74762_e("fuel");
        }
        return storedFuel;
    }

    public void setMaxFuel(ItemStack stack, int amountMax) {
        this.writeMaxFuelToNBT(stack, amountMax);
    }

    public boolean hasMaxFuelSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxfuel")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxFuelToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxfuel", value);
        stack.func_77982_d(compound);
    }

    public int readMaxFuelFromNBT(ItemStack stack) {
        int maxfuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxfuel = getCompound.func_74762_e("maxfuel");
        }
        return maxfuel;
    }

    public boolean addFuel(PedestalTileEntity pedestal, int amountToAdd, boolean simulate) {
        int currentFuel;
        int addAmount;
        int maxFuel;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasMaxFuelSet(coin) && (maxFuel = this.readMaxFuelFromNBT(coin)) > (addAmount = (currentFuel = this.getFuelStored(coin)) + amountToAdd)) {
            if (!simulate) {
                this.setFuelStored(coin, addAmount);
                pedestal.update();
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean removeFuel(World world, BlockPos posPedestal, int amountToRemove, boolean simulate) {
        TileEntity entity = world.func_175625_s(posPedestal);
        if (entity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)entity;
            return this.removeFuel(pedestal, amountToRemove, simulate);
        }
        return false;
    }

    public boolean removeFuel(PedestalTileEntity pedestal, int amountToRemove, boolean simulate) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasFuel(coin)) {
            int fuelLeft = this.getFuelStored(coin);
            int amountToSet = fuelLeft - amountToRemove;
            if (fuelLeft >= amountToRemove) {
                if (!simulate) {
                    if (amountToSet == -1) {
                        amountToSet = 0;
                    }
                    this.setFuelStored(coin, amountToSet);
                    pedestal.update();
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static int getItemFuelBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeHooks.getBurnTime((ItemStack)fuel);
        return burnTime;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        int getBurnTimeForStack;
        ItemStack getItemStack;
        if (entityIn instanceof ItemEntity && ItemUpgradeBaseMachine.getItemFuelBurnTime(getItemStack = ((ItemEntity)entityIn).func_92059_d()) > 0 && this.addFuel(tilePedestal, getBurnTimeForStack = ItemUpgradeBaseMachine.getItemFuelBurnTime(getItemStack) * getItemStack.func_190916_E(), true)) {
            this.addFuel(tilePedestal, getBurnTimeForStack, false);
            if (getItemStack.func_77973_b().equals(Items.field_151129_at)) {
                ItemStack getReturned = new ItemStack((IItemProvider)Items.field_151133_ar, getItemStack.func_190916_E());
                ItemEntity items1 = new ItemEntity(world, (double)posPedestal.func_177958_n() + 0.5, (double)posPedestal.func_177956_o() + 1.0, (double)posPedestal.func_177952_p() + 0.5, getReturned);
                if (!tilePedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
                entityIn.func_70106_y();
                world.func_217376_c((Entity)items1);
            }
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.25f, 1.0f);
            }
            entityIn.func_70106_y();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        int fuelValue;
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && (fuelValue = this.getFuelStored(pedestal.getCoinOnPedestal())) >= 200) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, ParticleTypes.field_197631_x);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        int fuelLeft = this.getFuelStored(pedestal.getCoinOnPedestal());
        TranslationTextComponent fuel = new TranslationTextComponent(this.func_77658_a() + ".chat_fuel");
        fuel.func_240702_b_("" + fuelLeft / 200 + "");
        fuel.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)fuel, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s2 = this.getItemTransferRate(stack);
        String trr = this.getOperationSpeedString(stack);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + s2 + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(trr);
        rate.func_240699_a_(TextFormatting.GRAY);
        TranslationTextComponent fuelStored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fuelstored");
        fuelStored.func_240702_b_("" + this.getFuelStored(stack) + "");
        fuelStored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)fuelStored);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }
}

