/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalFilters;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.item.ItemFilterSwapper;
import com.mowmaster.pedestals.item.pedestalFilters.ItemFilterItem;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemFilterBase
extends Item
implements IFilterBase {
    public boolean filterType = false;
    public static final Item BASEFILTER = (Item)new ItemFilterItem(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "filter/filterbase"));

    public ItemFilterBase(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean getFilterType() {
        return this.filterType;
    }

    @Override
    public boolean getFilterType(ItemStack filterItem) {
        this.getFilterTypeFromNBT(filterItem);
        return this.getFilterType();
    }

    @Override
    public void setFilterType(ItemStack filterItem, boolean filterSet) {
        this.filterType = filterSet;
        this.writeFilterTypeToNBT(filterItem);
    }

    public static int getColorFromNBT(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("filter_type")) {
            CompoundNBT getCompound = stack.func_77978_p();
            return getCompound.func_74767_n("filter_type") ? 0 : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean canAcceptItem(PedestalTileEntity pedestal, ItemStack itemStackIn) {
        return true;
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        return true;
    }

    @Override
    public int canAcceptCount(PedestalTileEntity pedestal, ItemStack itemStackIncoming) {
        return this.canAcceptCount(pedestal, pedestal.func_145831_w(), pedestal.func_174877_v(), pedestal.getItemInPedestal(), itemStackIncoming);
    }

    @Override
    public int canAcceptCount(PedestalTileEntity pedestal, World world, BlockPos posPedestal, ItemStack inPedestal, ItemStack itemStackIncoming) {
        return Math.min(pedestal.getSlotSizeLimit(), itemStackIncoming.func_77976_d());
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null) {
            ItemStack itemInHand;
            if (p_77659_2_.func_184586_b(p_77659_3_).func_77973_b().equals(BASEFILTER)) {
                return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            if (result.func_216346_c() == RayTraceResult.Type.MISS && p_77659_2_.func_213453_ef()) {
                ItemStack itemInHand2 = p_77659_2_.func_184586_b(p_77659_3_);
                ItemStack itemInMainHand = p_77659_2_.func_184614_ca();
                ItemStack itemInOffHand = p_77659_2_.func_184592_cb();
                if (itemInOffHand.func_77973_b() instanceof ItemFilterSwapper) {
                    if (itemInMainHand.func_77973_b() instanceof IFilterBase) {
                        this.removeFilterQueueHandler(itemInMainHand);
                        TranslationTextComponent output = new TranslationTextComponent("Filter Cleared");
                        output.func_240699_a_(TextFormatting.WHITE);
                        p_77659_2_.func_146105_b((ITextComponent)output, true);
                        return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
                    }
                } else if (itemInHand2.func_77973_b() instanceof IFilterBase) {
                    boolean getCurrentType = this.getFilterType(itemInHand2);
                    this.setFilterType(itemInHand2, !getCurrentType);
                    TranslationTextComponent changed = new TranslationTextComponent("pedestals.filters.tooltip_filterchange");
                    changed.func_240699_a_(TextFormatting.GREEN);
                    TranslationTextComponent white = new TranslationTextComponent("pedestals.filters.tooltip_filterwhite");
                    TranslationTextComponent black = new TranslationTextComponent("pedestals.filters.tooltip_filterblack");
                    changed.func_230529_a_((ITextComponent)(!getCurrentType ? black : white));
                    p_77659_2_.func_146105_b((ITextComponent)changed, true);
                    return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
                }
                return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK && p_77659_2_.func_213453_ef() && (itemInHand = p_77659_2_.func_184586_b(p_77659_3_)).func_77973_b() instanceof IFilterBase) {
                ItemUseContext context = new ItemUseContext(p_77659_2_, p_77659_3_, (BlockRayTraceResult)result);
                BlockRayTraceResult res = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), false);
                BlockPos posBlock = res.func_216350_a();
                List<ItemStack> buildQueue = this.buildFilterQueue(p_77659_1_, posBlock);
                if (buildQueue.size() > 0) {
                    this.writeFilterQueueToNBT(itemInHand, buildQueue);
                    return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
                }
                return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    @Override
    public void removeFilterQueueHandler(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("filterqueue")) {
            compound.func_82580_o("filterqueue");
            stack.func_77982_d(compound);
        }
    }

    @Override
    public int filterQueueSize(ItemStack coin) {
        CompoundNBT getCompound;
        int filterQueueSize = 0;
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("filterqueue")) {
            getCompound.func_74781_a("filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(getCompound);
            return handler.getSlots();
        }
        return filterQueueSize;
    }

    @Override
    public List<ItemStack> buildFilterQueue(World world, BlockPos invBlock) {
        IItemHandler handler;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        LazyOptional<IItemHandler> cap = ItemFilterBase.findItemHandlerAtPos(world, invBlock, true);
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.func_190926_b()) continue;
                filterQueue.add(stackInSlot);
            }
        }
        return filterQueue;
    }

    @Override
    public void writeFilterQueueToNBT(ItemStack stack, List<ItemStack> listIn) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT compoundStorage = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listIn.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listIn.get(i));
        }
        compoundStorage = handler.serializeNBT();
        compound.func_218657_a("filterqueue", (INBT)compoundStorage);
        stack.func_77982_d(compound);
    }

    @Override
    public List<ItemStack> readFilterQueueFromNBT(ItemStack filter) {
        CompoundNBT getCompound;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        if (filter.func_77942_o() && (getCompound = filter.func_77978_p()).func_74764_b("filterqueue")) {
            CompoundNBT invTag = getCompound.func_74775_l("filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((INBT)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                filterQueue.add(handler.getStackInSlot(i));
            }
        }
        return filterQueue;
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(World world, BlockPos pos, boolean allowCart) {
        LazyOptional cap;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return cap;
        }
        if (allowCart) {
            List list;
            if (AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos)) {
                LazyOptional cap2;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart);
                if (!list.isEmpty() && (cap2 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                    return cap2;
                }
            } else {
                LazyOptional cap3;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof BoatEntity);
                if (!list.isEmpty() && (cap3 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                    return cap3;
                }
            }
        }
        return LazyOptional.empty();
    }

    public boolean doesFilterAndQueueMatch(List<ItemStack> filterIn, List<ItemStack> queueMatch) {
        int matching = 0;
        if (filterIn.size() == queueMatch.size()) {
            for (int i = 0; i < filterIn.size() && this.doItemsMatchWithEmpty(filterIn.get(i), queueMatch.get(i)); ++i) {
                ++matching;
            }
        }
        return matching == filterIn.size();
    }

    public boolean doItemsMatchWithEmpty(ItemStack stackPedestal, ItemStack itemStackIn) {
        if (stackPedestal.func_190926_b() && itemStackIn.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    @Override
    public void writeFilterTypeToNBT(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74757_a("filter_type", this.filterType);
        stack.func_77982_d(compound);
    }

    @Override
    public boolean getFilterTypeFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            this.filterType = getCompound.func_74767_n("filter_type");
        }
        return this.filterType;
    }

    public boolean doItemsMatch(ItemStack stackPedestal, ItemStack itemStackIn) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack filterStack = pedestal.getFilterInPedestal();
        if (!filterStack.func_77973_b().equals(BASEFILTER)) {
            TranslationTextComponent filterList = new TranslationTextComponent(filterStack.func_200301_q().getString());
            filterList.func_240699_a_(TextFormatting.GOLD);
            player.func_145747_a((ITextComponent)filterList, Util.field_240973_b_);
            List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack);
            if (filterQueue.size() > 0) {
                TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
                enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
                player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
                for (int i = 0; i < filterQueue.size(); ++i) {
                    if (filterQueue.get(i).func_190926_b()) continue;
                    TranslationTextComponent enchants = new TranslationTextComponent(filterQueue.get(i).func_200301_q().getString());
                    enchants.func_240699_a_(TextFormatting.GRAY);
                    player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
                }
            }
        } else {
            TranslationTextComponent base = new TranslationTextComponent("pedestals.baseItem");
            base.func_240699_a_(TextFormatting.DARK_RED);
            player.func_145747_a((ITextComponent)base, Util.field_240973_b_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!stack.func_77973_b().equals(BASEFILTER)) {
            boolean filterType = this.getFilterType(stack);
            TranslationTextComponent filterList = new TranslationTextComponent("pedestals.filters.tooltip_filtertype");
            TranslationTextComponent white = new TranslationTextComponent("pedestals.filters.tooltip_filterwhite");
            TranslationTextComponent black = new TranslationTextComponent("pedestals.filters.tooltip_filterblack");
            filterList.func_230529_a_((ITextComponent)(filterType ? black : white));
            filterList.func_240699_a_(TextFormatting.GOLD);
            tooltip.add((ITextComponent)filterList);
            List<ItemStack> filterQueue = this.readFilterQueueFromNBT(stack);
            if (filterQueue.size() > 0) {
                TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
                enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
                tooltip.add((ITextComponent)enchant);
                for (int i = 0; i < filterQueue.size(); ++i) {
                    if (filterQueue.get(i).func_190926_b()) continue;
                    TranslationTextComponent enchants = new TranslationTextComponent(filterQueue.get(i).func_200301_q().getString());
                    enchants.func_240699_a_(TextFormatting.GRAY);
                    tooltip.add((ITextComponent)enchants);
                }
            }
        } else {
            TranslationTextComponent base = new TranslationTextComponent("pedestals.baseItem");
            base.func_240699_a_(TextFormatting.DARK_RED);
            tooltip.add((ITextComponent)base);
        }
    }

    public static void handleItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((itemstack, tintIndex) -> {
            if (tintIndex == 1) {
                return ItemFilterBase.getColorFromNBT(itemstack);
            }
            return -1;
        }, new IItemProvider[]{BASEFILTER});
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)BASEFILTER);
    }
}

