/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.enchants;

import com.google.common.base.Preconditions;
import com.mowmaster.pedestals.api.enchanting.IEnchantableBook;
import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.enchants.EnchantmentAdvanced;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentMagnet;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="pedestals", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class EnchantmentRegistry {
    public static final EnchantmentType COINUPGRADE = EnchantmentType.create((String)"pedestalupgrade", item -> item instanceof IEnchantableBook || item instanceof IUpgradeBase);
    public static final Enchantment OPERATIONSPEED = new EnchantmentOperationSpeed();
    public static final Enchantment RANGE = new EnchantmentRange();
    public static final Enchantment AREA = new EnchantmentArea();
    public static final Enchantment CAPACITY = new EnchantmentCapacity();
    public static final Enchantment ADVANCED = new EnchantmentAdvanced();
    public static final Enchantment MAGNET = new EnchantmentMagnet();

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Enchantment[]{EnchantmentRegistry.setup(OPERATIONSPEED, "upgradespeed"), EnchantmentRegistry.setup(RANGE, "upgraderange"), EnchantmentRegistry.setup(AREA, "upgradearea"), EnchantmentRegistry.setup(CAPACITY, "upgradecapacity"), EnchantmentRegistry.setup(ADVANCED, "upgradeadvanced"), EnchantmentRegistry.setup(MAGNET, "upgrademagnet")});
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull String name) {
        return EnchantmentRegistry.setup(entry, new ResourceLocation("pedestals", name));
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull ResourceLocation registryName) {
        Preconditions.checkNotNull(entry, (Object)"Entry cannot be null!");
        Preconditions.checkNotNull((Object)registryName, (Object)"Registry name to assign to entry cannot be null!");
        entry.setRegistryName(registryName);
        return entry;
    }
}

