/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.compat.rei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.mixin.itemgroup.CreativeInventoryScreenAccessor;
import io.wispforest.owo.mixin.ui.access.BaseOwoHandledScreenAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.ScissorStack;
import io.wispforest.owo.util.pond.OwoCreativeInventoryScreenExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1761;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_481;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OwoReiPlugin
implements REIClientPlugin {
    @Nullable
    private static OverlayRendererProvider.Sink renderSink = null;

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(class_481.class, screen -> {
            class_1761 group = CreativeInventoryScreenAccessor.owo$getSelectedTab();
            if (!(group instanceof OwoItemGroup)) {
                return Collections.emptySet();
            }
            OwoItemGroup owoGroup = (OwoItemGroup)group;
            if (owoGroup.getButtons().isEmpty()) {
                return Collections.emptySet();
            }
            int x = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootX();
            int y = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootY();
            int stackHeight = owoGroup.getButtonStackHeight();
            y -= 13 * (stackHeight - 4);
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (int i = 0; i < owoGroup.getButtons().size(); ++i) {
                int xOffset = x + 198 + i / stackHeight * 26;
                int yOffset = y + 10 + i % stackHeight * 30;
                rectangles.add(new Rectangle(xOffset, yOffset, 24, 24));
            }
            return rectangles;
        });
        zones.register(BaseOwoHandledScreen.class, screen -> {
            if (screen.method_25396().isEmpty()) {
                return List.of();
            }
            OwoUIAdapter<?> adapter = ((BaseOwoHandledScreenAccessor)((Object)screen)).owo$getUIAdapter();
            if (adapter == null) {
                return List.of();
            }
            Object rootComponent = adapter.rootComponent;
            ArrayList<Component> children = new ArrayList<Component>();
            rootComponent.collectDescendants(children);
            children.remove(rootComponent);
            ArrayList rectangles = new ArrayList();
            children.forEach(component -> {
                ParentComponent parent;
                if (component instanceof ParentComponent && (parent = (ParentComponent)component).surface() == Surface.BLANK) {
                    return;
                }
                Size size = component.fullSize();
                rectangles.add(new Rectangle(component.x(), component.y(), size.width(), size.height()));
            });
            return rectangles;
        });
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new OverlayDecider(){

            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return BaseOwoHandledScreen.class.isAssignableFrom(screen);
            }

            public OverlayRendererProvider getRendererProvider() {
                return new OverlayRendererProvider(){

                    public void onApplied(OverlayRendererProvider.Sink sink) {
                        renderSink = sink;
                    }

                    public void onRemoved() {
                        renderSink = null;
                    }
                };
            }
        });
    }

    private static void renderOverlay(class_437 screen, Runnable renderFunction) {
        if (REIRuntime.getInstance().getSearchTextField().getText().equals("froge")) {
            class_4587 modelView = RenderSystem.getModelViewStack();
            long time = System.currentTimeMillis();
            float scale = 0.75f + (float)(Math.sin((double)time / 500.0) * 0.5);
            modelView.method_22903();
            modelView.method_46416((float)screen.field_22789 / 2.0f - scale / 2.0f * (float)screen.field_22789, (float)screen.field_22790 / 2.0f - scale / 2.0f * (float)screen.field_22790, 0.0f);
            modelView.method_22905(scale, scale, 1.0f);
            modelView.method_46416((float)(Math.sin((double)time / 1000.0) * 0.75) * (float)screen.field_22789, (float)(Math.sin((double)time / 500.0) * 0.75) * (float)screen.field_22790, 0.0f);
            modelView.method_46416((float)screen.field_22789 / 2.0f, (float)screen.field_22790 / 2.0f, 0.0f);
            modelView.method_22907(class_7833.field_40718.rotationDegrees((float)((double)time / 25.0 % 360.0)));
            modelView.method_46416((float)screen.field_22789 / -2.0f, (float)screen.field_22790 / -2.0f, 0.0f);
            for (int i = 0; i < 20; ++i) {
                modelView.method_22903();
                modelView.method_46416((float)screen.field_22789 / 2.0f, (float)screen.field_22790 / 2.0f, 0.0f);
                modelView.method_22907(class_7833.field_40718.rotationDegrees((float)(i * 18)));
                modelView.method_46416((float)screen.field_22789 / -2.0f, (float)screen.field_22790 / -2.0f, 0.0f);
                RenderSystem.applyModelViewMatrix();
                ScissorStack.pushDirect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                renderFunction.run();
                GlStateManager._enableScissorTest();
                ScissorStack.pop();
                modelView.method_22909();
            }
            modelView.method_22909();
            RenderSystem.applyModelViewMatrix();
        } else {
            ScissorStack.pushDirect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            renderFunction.run();
            GlStateManager._enableScissorTest();
            ScissorStack.pop();
        }
    }

    static {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof BaseOwoHandledScreenAccessor)) {
                return;
            }
            BaseOwoHandledScreenAccessor accessor = (BaseOwoHandledScreenAccessor)screen;
            ScreenEvents.beforeRender((class_437)screen).register(($, context, mouseX, mouseY, tickDelta) -> {
                Object root = accessor.owo$getUIAdapter().rootComponent;
                Surface patt5041$temp = root.surface();
                if (patt5041$temp instanceof CallbackSurface) {
                    CallbackSurface wrapped;
                    surface = wrapped = (CallbackSurface)patt5041$temp;
                } else {
                    surface = new CallbackSurface(root.surface());
                    root.surface(surface);
                }
                surface.callback = () -> {
                    if (renderSink == null) {
                        return;
                    }
                    OwoReiPlugin.renderOverlay($, () -> renderSink.render(context, mouseX, mouseY, tickDelta));
                };
            });
            ScreenEvents.afterRender((class_437)screen).register(($, matrices, mouseX, mouseY, tickDelta) -> {
                if (renderSink == null) {
                    return;
                }
                OwoReiPlugin.renderOverlay($, () -> renderSink.lateRender(matrices, mouseX, mouseY, tickDelta));
            });
        });
    }

    private static class CallbackSurface
    implements Surface {
        public final Surface inner;
        @NotNull
        public Runnable callback = () -> {};

        private CallbackSurface(Surface inner) {
            this.inner = inner;
        }

        @Override
        public void draw(OwoUIDrawContext context, ParentComponent component) {
            this.inner.draw(context, component);
            this.callback.run();
        }
    }
}

