/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import repack.apache.commons.collections4.bloomfilter.BitMap;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;
import repack.apache.commons.collections4.bloomfilter.BloomFilter;
import repack.apache.commons.collections4.bloomfilter.CountingLongPredicate;
import repack.apache.commons.collections4.bloomfilter.Hasher;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;
import repack.apache.commons.collections4.bloomfilter.LongBiPredicate;
import repack.apache.commons.collections4.bloomfilter.SetOperations;
import repack.apache.commons.collections4.bloomfilter.Shape;

public final class SimpleBloomFilter
implements BloomFilter {
    private final long[] bitMap;
    private final Shape shape;
    private int cardinality;

    public SimpleBloomFilter(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        this.shape = shape;
        this.bitMap = new long[BitMap.numberOfBitMaps(shape.getNumberOfBits())];
        this.cardinality = 0;
    }

    private SimpleBloomFilter(SimpleBloomFilter source) {
        this.shape = source.shape;
        this.bitMap = (long[])source.bitMap.clone();
        this.cardinality = source.cardinality;
    }

    @Override
    public void clear() {
        Arrays.fill(this.bitMap, 0L);
        this.cardinality = 0;
    }

    @Override
    public long[] asBitMapArray() {
        return Arrays.copyOf(this.bitMap, this.bitMap.length);
    }

    @Override
    public boolean forEachBitMapPair(BitMapProducer other, LongBiPredicate func) {
        CountingLongPredicate p = new CountingLongPredicate(this.bitMap, func);
        return other.forEachBitMap(p) && p.forEachRemaining();
    }

    @Override
    public SimpleBloomFilter copy() {
        return new SimpleBloomFilter(this);
    }

    @Override
    public boolean merge(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        indexProducer.forEachIndex(idx -> {
            if (idx < 0 || idx >= this.shape.getNumberOfBits()) {
                throw new IllegalArgumentException(String.format("IndexProducer should only send values in the range[0,%s)", this.shape.getNumberOfBits()));
            }
            BitMap.set(this.bitMap, idx);
            return true;
        });
        this.cardinality = -1;
        return true;
    }

    @Override
    public boolean merge(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        try {
            long excess;
            int[] idx = new int[1];
            bitMapProducer.forEachBitMap(value -> {
                int n = idx[0];
                idx[0] = n + 1;
                this.bitMap[n] = this.bitMap[n] | value;
                return true;
            });
            idx[0] = idx[0] - 1;
            int idxLimit = BitMap.getLongIndex(this.shape.getNumberOfBits());
            if (idxLimit < idx[0]) {
                throw new IllegalArgumentException(String.format("BitMapProducer set a bit higher than the limit for the shape: %s", this.shape.getNumberOfBits() - 1));
            }
            if (idxLimit == idx[0] && (excess = this.bitMap[idxLimit] >> this.shape.getNumberOfBits()) != 0L) {
                throw new IllegalArgumentException(String.format("BitMapProducer set a bit higher than the limit for the shape: %s", this.shape.getNumberOfBits()));
            }
            this.cardinality = -1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("BitMapProducer should send at most %s maps", this.bitMap.length), e);
        }
        return true;
    }

    @Override
    public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.shape));
    }

    @Override
    public boolean merge(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        if ((other.characteristics() & 1) != 0) {
            this.merge((IndexProducer)other);
        } else {
            this.merge((BitMapProducer)other);
        }
        return true;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public int characteristics() {
        return 0;
    }

    @Override
    public int cardinality() {
        int c = this.cardinality;
        if (c < 0) {
            this.cardinality = c = SetOperations.cardinality(this);
        }
        return c;
    }

    @Override
    public boolean forEachIndex(IntPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return IndexProducer.fromBitMapProducer(this).forEachIndex(consumer);
    }

    @Override
    public boolean forEachBitMap(LongPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        for (long l : this.bitMap) {
            if (consumer.test(l)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(IndexProducer indexProducer) {
        return indexProducer.forEachIndex(idx -> BitMap.contains(this.bitMap, idx));
    }
}

