/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.function.LongBinaryOperator;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;
import repack.apache.commons.collections4.bloomfilter.BloomFilter;

public final class SetOperations {
    private static int cardinality(BitMapProducer first, BitMapProducer second, LongBinaryOperator op) {
        int[] cardinality = new int[1];
        first.forEachBitMapPair(second, (x, y) -> {
            cardinality[0] = cardinality[0] + Long.bitCount(op.applyAsLong(x, y));
            return true;
        });
        return cardinality[0];
    }

    public static int cardinality(BitMapProducer producer) {
        int[] cardinality = new int[1];
        producer.forEachBitMap(l -> {
            cardinality[0] = cardinality[0] + Long.bitCount(l);
            return true;
        });
        return cardinality[0];
    }

    public static int andCardinality(BitMapProducer first, BitMapProducer second) {
        return SetOperations.cardinality(first, second, (x, y) -> x & y);
    }

    public static int orCardinality(BitMapProducer first, BitMapProducer second) {
        return SetOperations.cardinality(first, second, (x, y) -> x | y);
    }

    public static int xorCardinality(BitMapProducer first, BitMapProducer second) {
        return SetOperations.cardinality(first, second, (x, y) -> x ^ y);
    }

    public static double cosineDistance(BitMapProducer first, BitMapProducer second) {
        return 1.0 - SetOperations.cosineSimilarity(first, second);
    }

    public static double cosineSimilarity(BitMapProducer first, BitMapProducer second) {
        int numerator = SetOperations.andCardinality(first, second);
        return numerator == 0 ? 0.0 : (double)numerator / Math.sqrt(SetOperations.cardinality(first) * SetOperations.cardinality(second));
    }

    public static double cosineSimilarity(BloomFilter first, BloomFilter second) {
        int numerator = SetOperations.andCardinality(first, second);
        return numerator == 0 ? 0.0 : (double)numerator / Math.sqrt(first.cardinality() * second.cardinality());
    }

    public static int hammingDistance(BitMapProducer first, BitMapProducer second) {
        return SetOperations.xorCardinality(first, second);
    }

    public static double jaccardDistance(BitMapProducer first, BitMapProducer second) {
        return 1.0 - SetOperations.jaccardSimilarity(first, second);
    }

    public static double jaccardSimilarity(BitMapProducer first, BitMapProducer second) {
        int[] cardinality = new int[2];
        first.forEachBitMapPair(second, (x, y) -> {
            cardinality[0] = cardinality[0] + Long.bitCount(x & y);
            cardinality[1] = cardinality[1] + Long.bitCount(x | y);
            return true;
        });
        int intersection = cardinality[0];
        return intersection == 0 ? 0.0 : (double)intersection / (double)cardinality[1];
    }

    private SetOperations() {
    }
}

