/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import java.util.stream.StreamSupport;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.mixin.DimensionTypeAccessor;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.world.GameType;

public class IrisExclusiveUniforms {
    public static void addIrisExclusiveUniforms(UniformHolder uniforms) {
        WorldInfoUniforms.addWorldInfoUniforms(uniforms);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
        Vector4f zero = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        uniforms.uniform4f(UniformUpdateFrequency.PER_TICK, "lightningBoltPosition", () -> {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                return StreamSupport.stream(Minecraft.func_71410_x().field_71441_e.func_217416_b().spliterator(), false).filter(bolt -> bolt instanceof LightningBoltEntity).findAny().map(bolt -> {
                    Vector3d unshiftedCameraPosition = CameraUniforms.getUnshiftedCameraPosition();
                    net.minecraft.util.math.vector.Vector3d vec3 = bolt.func_242282_l(Minecraft.func_71410_x().func_193989_ak());
                    return new Vector4f((float)(vec3.field_72450_a - unshiftedCameraPosition.x), (float)(vec3.field_72448_b - unshiftedCameraPosition.y), (float)(vec3.field_72449_c - unshiftedCameraPosition.z), 1.0f);
                }).orElse(zero);
            }
            return zero;
        });
    }

    private static float getThunderStrength() {
        return Math.clamp(0.0f, 1.0f, Minecraft.func_71410_x().field_71441_e.func_72819_i(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static float getCurrentHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77144_e()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110143_aJ() / Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static float getCurrentHunger() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77144_e()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_71024_bL().func_75116_a() / 20.0f;
    }

    private static float getCurrentAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77144_e()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_70086_ai() / (float)Minecraft.func_71410_x().field_71439_g.func_205010_bg();
    }

    private static float getMaxAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77144_e()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_205010_bg();
    }

    private static float getMaxHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77144_e()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static boolean isFirstPersonCamera() {
        switch (Minecraft.func_71410_x().field_71474_y.func_243230_g()) {
            case THIRD_PERSON_BACK: 
            case THIRD_PERSON_FRONT: {
                return false;
            }
        }
        return true;
    }

    private static boolean isSpectator() {
        return Minecraft.func_71410_x().field_71442_b.func_178889_l() == GameType.SPECTATOR;
    }

    private static Vector3d getEyePosition() {
        Objects.requireNonNull(Minecraft.func_71410_x().func_175606_aa());
        return new Vector3d(Minecraft.func_71410_x().func_175606_aa().func_226277_ct_(), Minecraft.func_71410_x().func_175606_aa().func_226280_cw_(), Minecraft.func_71410_x().func_175606_aa().func_226281_cx_());
    }

    public static class WorldInfoUniforms {
        public static void addWorldInfoUniforms(UniformHolder uniforms) {
            ClientWorld level = Minecraft.func_71410_x().field_71441_e;
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "bedrockLevel", () -> 0);
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heightLimit", () -> {
                if (level != null) {
                    return level.func_217301_I();
                }
                return 256;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasCeiling", () -> {
                if (level != null) {
                    return level.func_230315_m_().func_236037_d_();
                }
                return false;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasSkylight", () -> {
                if (level != null) {
                    return level.func_230315_m_().func_218272_d();
                }
                return true;
            });
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "ambientLight", () -> {
                if (level != null) {
                    return ((DimensionTypeAccessor)level.func_230315_m_()).getAmbientLight();
                }
                return 0.0f;
            });
        }
    }
}

