/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.statelisteners.BooleanStateAccessor;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.TextureTracker;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.ExternallyManagedUniforms;
import net.coderbot.iris.uniforms.FogUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.HardcodedCustomUniforms;
import net.coderbot.iris.uniforms.IdMapUniforms;
import net.coderbot.iris.uniforms.IrisExclusiveUniforms;
import net.coderbot.iris.uniforms.MatrixUniforms;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.ViewportUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.uniforms.transforms.SmoothedVec2f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;

public final class CommonUniforms {
    private static final Minecraft client = Minecraft.func_71410_x();
    private static final Vector2i ZERO_VECTOR_2i = new Vector2i();
    private static final Vector4i ZERO_VECTOR_4i = new Vector4i(0, 0, 0, 0);
    private static final net.coderbot.iris.vendored.joml.Vector3d ZERO_VECTOR_3d = new net.coderbot.iris.vendored.joml.Vector3d();

    private CommonUniforms() {
    }

    public static void addCommonUniforms(DynamicUniformHolder uniforms, IdMap idMap, PackDirectives directives, FrameUpdateNotifier updateNotifier) {
        CameraUniforms.addCameraUniforms(uniforms, updateNotifier);
        ViewportUniforms.addViewportUniforms(uniforms);
        WorldTimeUniforms.addWorldTimeUniforms(uniforms);
        SystemTimeUniforms.addSystemTimeUniforms(uniforms);
        new CelestialUniforms(directives.getSunPathRotation()).addCelestialUniforms(uniforms);
        IdMapUniforms.addIdMapUniforms(updateNotifier, uniforms, idMap, directives.isOldHandLight());
        IrisExclusiveUniforms.addIrisExclusiveUniforms(uniforms);
        MatrixUniforms.addMatrixUniforms(uniforms, directives);
        HardcodedCustomUniforms.addHardcodedCustomUniforms(uniforms, updateNotifier);
        FogUniforms.addFogUniforms(uniforms);
        uniforms.uniform2i("atlasSize", () -> {
            int glId = GlStateManagerAccessor.getTEXTURES()[0].field_179059_b;
            Texture texture = TextureTracker.INSTANCE.getTexture(glId);
            if (texture instanceof AtlasTexture) {
                TextureInfoCache.TextureInfo info = TextureInfoCache.INSTANCE.getInfo(glId);
                return new Vector2i(info.getWidth(), info.getHeight());
            }
            return ZERO_VECTOR_2i;
        }, StateUpdateNotifiers.bindTextureNotifier);
        uniforms.uniform2i("gtextureSize", () -> {
            int glId = GlStateManagerAccessor.getTEXTURES()[0].field_179059_b;
            TextureInfoCache.TextureInfo info = TextureInfoCache.INSTANCE.getInfo(glId);
            return new Vector2i(info.getWidth(), info.getHeight());
        }, StateUpdateNotifiers.bindTextureNotifier);
        uniforms.uniform4i("blendFunc", () -> {
            GlStateManager.BlendState blend = GlStateManagerAccessor.getBLEND();
            if (((BooleanStateAccessor)blend.field_179213_a).isEnabled()) {
                return new Vector4i(blend.field_179211_b, blend.field_179212_c, blend.field_179209_d, blend.field_179210_e);
            }
            return ZERO_VECTOR_4i;
        }, StateUpdateNotifiers.blendFuncNotifier);
        uniforms.uniform1i("renderStage", () -> GbufferPrograms.getCurrentPhase().ordinal(), StateUpdateNotifiers.phaseChangeNotifier);
        CommonUniforms.generalCommonUniforms(uniforms, updateNotifier, directives);
    }

    public static void generalCommonUniforms(UniformHolder uniforms, FrameUpdateNotifier updateNotifier, PackDirectives directives) {
        ExternallyManagedUniforms.addExternallyManagedUniforms116(uniforms);
        SmoothedVec2f eyeBrightnessSmooth = new SmoothedVec2f(directives.getEyeBrightnessHalfLife(), directives.getEyeBrightnessHalfLife(), CommonUniforms::getEyeBrightness, updateNotifier);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hideGUI", () -> CommonUniforms.client.field_71474_y.field_74319_N).uniform1f(UniformUpdateFrequency.PER_FRAME, "eyeAltitude", () -> Objects.requireNonNull(client.func_175606_aa()).func_226280_cw_()).uniform1i(UniformUpdateFrequency.PER_FRAME, "isEyeInWater", CommonUniforms::isEyeInWater).uniform1f(UniformUpdateFrequency.PER_FRAME, "blindness", CommonUniforms::getBlindness).uniform1f(UniformUpdateFrequency.PER_FRAME, "nightVision", CommonUniforms::getNightVision).uniform1f(UniformUpdateFrequency.PER_FRAME, "screenBrightness", () -> CommonUniforms.client.field_71474_y.field_74333_Y).uniform4f(UniformUpdateFrequency.ONCE, "entityColor", Vector4f::new).uniform1f(UniformUpdateFrequency.PER_TICK, "playerMood", CommonUniforms::getPlayerMood).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightness", CommonUniforms::getEyeBrightness).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessSmooth", () -> {
            Vector2f smoothed = eyeBrightnessSmooth.get();
            return new Vector2i((int)smoothed.x(), (int)smoothed.y());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "rainStrength", CommonUniforms::getRainStrength).uniform1f(UniformUpdateFrequency.PER_TICK, "wetness", new SmoothedFloat(directives.getWetnessHalfLife(), directives.getDrynessHalfLife(), CommonUniforms::getRainStrength, updateNotifier)).uniform3d(UniformUpdateFrequency.PER_FRAME, "skyColor", CommonUniforms::getSkyColor).uniform3d(UniformUpdateFrequency.PER_FRAME, "fogColor", CapturedRenderingState.INSTANCE::getFogColor);
    }

    private static net.coderbot.iris.vendored.joml.Vector3d getSkyColor() {
        if (CommonUniforms.client.field_71441_e == null || CommonUniforms.client.field_175622_Z == null) {
            return ZERO_VECTOR_3d;
        }
        return JomlConversions.fromVec3(CommonUniforms.client.field_71441_e.func_228318_a_(CommonUniforms.client.field_175622_Z.func_233580_cy_(), CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    static float getBlindness() {
        EffectInstance blindness;
        Entity cameraEntity = client.func_175606_aa();
        if (cameraEntity instanceof LivingEntity && (blindness = ((LivingEntity)cameraEntity).func_70660_b(Effects.field_76440_q)) != null) {
            return Math.clamp(0.0f, 1.0f, (float)blindness.func_76459_b() / 20.0f);
        }
        return 0.0f;
    }

    private static float getPlayerMood() {
        if (!(CommonUniforms.client.field_175622_Z instanceof ClientPlayerEntity)) {
            return 0.0f;
        }
        return Math.clamp(0.0f, 1.0f, ((ClientPlayerEntity)CommonUniforms.client.field_175622_Z).func_239206_w_());
    }

    static float getRainStrength() {
        if (CommonUniforms.client.field_71441_e == null) {
            return 0.0f;
        }
        return Math.clamp(0.0f, 1.0f, CommonUniforms.client.field_71441_e.func_72867_j(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static Vector2i getEyeBrightness() {
        if (CommonUniforms.client.field_175622_Z == null || CommonUniforms.client.field_71441_e == null) {
            return ZERO_VECTOR_2i;
        }
        Vector3d feet = CommonUniforms.client.field_175622_Z.func_213303_ch();
        Vector3d eyes = new Vector3d(feet.field_72450_a, CommonUniforms.client.field_175622_Z.func_226280_cw_(), feet.field_72449_c);
        BlockPos eyeBlockPos = new BlockPos(eyes);
        int blockLight = CommonUniforms.client.field_71441_e.func_226658_a_(LightType.BLOCK, eyeBlockPos);
        int skyLight = CommonUniforms.client.field_71441_e.func_226658_a_(LightType.SKY, eyeBlockPos);
        return new Vector2i(blockLight * 16, skyLight * 16);
    }

    private static float getNightVision() {
        float underwaterVisibility;
        Entity cameraEntity = client.func_175606_aa();
        if (cameraEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)cameraEntity;
            try {
                float nightVisionStrength = GameRenderer.func_180438_a((LivingEntity)livingEntity, (float)CapturedRenderingState.INSTANCE.getTickDelta());
                if (nightVisionStrength > 0.0f) {
                    return Math.clamp(0.0f, 1.0f, nightVisionStrength);
                }
            }
            catch (NullPointerException e) {
                return 0.0f;
            }
        }
        if (CommonUniforms.client.field_71439_g != null && CommonUniforms.client.field_71439_g.func_70644_a(Effects.field_205136_C) && (underwaterVisibility = CommonUniforms.client.field_71439_g.func_203719_J()) > 0.0f) {
            return Math.clamp(0.0f, 1.0f, underwaterVisibility);
        }
        return 0.0f;
    }

    static int isEyeInWater() {
        FluidState submergedFluid = CommonUniforms.client.field_71460_t.func_215316_n().func_216771_k();
        if (submergedFluid.func_206884_a((ITag)FluidTags.field_206959_a)) {
            return 1;
        }
        if (submergedFluid.func_206884_a((ITag)FluidTags.field_206960_b)) {
            return 2;
        }
        return 0;
    }

    static {
        GbufferPrograms.init();
    }
}

