/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.client.resources.Language;
import net.minecraft.resources.IResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ClientLanguageMap.class}, priority=990)
public class MixinClientLanguage {
    private static final String LOAD = "Lnet/minecraft/client/resources/language/ClientLanguage;loadFrom(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;)Lnet/minecraft/client/resources/language/ClientLanguage;";
    @Unique
    private static final List<String> languageCodes = new ArrayList<String>();
    @Shadow
    @Final
    private Map<String, String> field_239495_c_;

    @Inject(method={"loadFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/language/ClientLanguage;appendFrom(Ljava/util/List;Ljava/util/Map;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void injectFrom(IResourceManager arg, List<Language> list, CallbackInfoReturnable<ClientLanguageMap> cir, Map<String, String> map, boolean bl, Iterator<Language> infoIterator, Language info, String json) {
        if (Iris.class.getResource("/assets/iris/" + json) != null) {
            net.minecraft.util.text.LanguageMap.func_240593_a_((InputStream)Iris.class.getResourceAsStream("/assets/iris/" + json), map::put);
        }
    }

    @Inject(method={"getOrDefault"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$addLanguageEntries(String key, CallbackInfoReturnable<String> cir) {
        String override = this.iris$lookupOverriddenEntry(key);
        if (override != null) {
            cir.setReturnValue((Object)override);
        }
    }

    @Inject(method={"has"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$addLanguageEntriesToTranslationChecks(String key, CallbackInfoReturnable<Boolean> cir) {
        String override = this.iris$lookupOverriddenEntry(key);
        if (override != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private String iris$lookupOverriddenEntry(String key) {
        ShaderPack pack = Iris.getCurrentPack().orElse(null);
        if (pack == null) {
            return null;
        }
        LanguageMap languageMap = pack.getLanguageMap();
        if (this.field_239495_c_.containsKey(key)) {
            return null;
        }
        for (String code : languageCodes) {
            String translation;
            Map<String, String> translations = languageMap.getTranslations(code);
            if (translations == null || (translation = translations.get(key)) == null) continue;
            return translation;
        }
        return null;
    }

    @Inject(method={"Lnet/minecraft/client/resources/language/ClientLanguage;loadFrom(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;)Lnet/minecraft/client/resources/language/ClientLanguage;"}, at={@At(value="HEAD")})
    private static void check(IResourceManager resourceManager, List<Language> definitions, CallbackInfoReturnable<ClientLanguageMap> cir) {
        languageCodes.clear();
        new LinkedList<Language>(definitions).descendingIterator().forEachRemaining(languageDefinition -> languageCodes.add(languageDefinition.getCode()));
    }
}

