/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.widget.StringElementWidget;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuStringOptionElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class SliderElementWidget
extends StringElementWidget {
    private static final int PREVIEW_SLIDER_WIDTH = 4;
    private static final int ACTIVE_SLIDER_WIDTH = 6;
    private boolean mouseDown = false;

    public SliderElementWidget(OptionMenuStringOptionElement element) {
        super(element);
    }

    @Override
    public void render(MatrixStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        this.updateRenderParams(width, 35);
        if (!hovered) {
            this.renderOptionWithValue(poseStack, x, y, width, height, false, (float)this.valueIndex / (float)(this.valueCount - 1), 4);
        } else {
            this.renderSlider(poseStack, x, y, width, height, mouseX, mouseY, tickDelta);
        }
        if (Screen.func_231173_s_()) {
            this.renderTooltip(poseStack, SET_TO_DEFAULT, mouseX, mouseY, hovered);
        } else if (!this.screen.isDisplayingComment()) {
            this.renderTooltip(poseStack, (ITextComponent)this.unmodifiedLabel, mouseX, mouseY, hovered);
        }
        if (this.mouseDown) {
            if (!hovered) {
                this.onReleased();
            }
            this.whileDragging(x, width, mouseX);
        }
    }

    private void renderSlider(MatrixStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, false, false);
        GuiUtil.drawButton(poseStack, x + 2, y + 2, width - 4, height - 4, false, true);
        int sliderSpace = width - 8 - 6;
        int sliderPos = x + 4 + (int)((float)this.valueIndex / (float)(this.valueCount - 1) * (float)sliderSpace);
        GuiUtil.drawButton(poseStack, sliderPos, y + 4, 6, height - 8, this.mouseDown, false);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_243246_a(poseStack, this.valueLabel, (float)((int)((double)x + (double)width * 0.5) - (int)((double)font.func_238414_a_((ITextProperties)this.valueLabel) * 0.5)), (float)(y + 7), 0xFFFFFF);
    }

    private void whileDragging(int x, int width, int mouseX) {
        float mousePositionAcrossWidget = MathHelper.func_76131_a((float)((float)(mouseX - (x + 4)) / (float)(width - 8)), (float)0.0f, (float)1.0f);
        int newValueIndex = Math.min(this.valueCount - 1, (int)(mousePositionAcrossWidget * (float)this.valueCount));
        if (this.valueIndex != newValueIndex) {
            this.valueIndex = newValueIndex;
            this.updateLabels();
        }
    }

    private void onReleased() {
        this.mouseDown = false;
        this.queue();
        this.navigation.refresh();
        GuiUtil.playButtonClickSound();
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0) {
            if (Screen.func_231173_s_()) {
                if (this.applyOriginalValue()) {
                    this.navigation.refresh();
                }
                GuiUtil.playButtonClickSound();
                return true;
            }
            this.mouseDown = true;
            GuiUtil.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mx, double my, int button) {
        if (button == 0) {
            this.onReleased();
            return true;
        }
        return super.mouseReleased(mx, my, button);
    }
}

