/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class GuiUtil {
    public static final ResourceLocation IRIS_WIDGETS_TEX = new ResourceLocation("iris", "textures/gui/widgets.png");
    private static final ITextComponent ELLIPSIS = new StringTextComponent("...");

    private GuiUtil() {
    }

    private static Minecraft client() {
        return Minecraft.func_71410_x();
    }

    public static void bindIrisWidgetsTexture() {
        GuiUtil.client().func_110434_K().func_110577_a(IRIS_WIDGETS_TEX);
    }

    public static void drawButton(MatrixStack poseStack, int x, int y, int width, int height, boolean hovered, boolean disabled) {
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int vOffset = disabled ? 46 : (hovered ? 86 : 66);
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)x, (int)y, (float)0.0f, (float)vOffset, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(x + halfWidth), (int)y, (float)(200 - (width - halfWidth)), (float)vOffset, (int)(width - halfWidth), (int)halfHeight, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)x, (int)(y + halfHeight), (float)0.0f, (float)(vOffset + (20 - (height - halfHeight))), (int)halfWidth, (int)(height - halfHeight), (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(x + halfWidth), (int)(y + halfHeight), (float)(200 - (width - halfWidth)), (float)(vOffset + (20 - (height - halfHeight))), (int)(width - halfWidth), (int)(height - halfHeight), (int)256, (int)256);
    }

    public static void drawPanel(MatrixStack poseStack, int x, int y, int width, int height) {
        int borderColor = -555819298;
        int innerColor = -570425344;
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)innerColor);
    }

    public static void drawTextPanel(FontRenderer font, MatrixStack poseStack, ITextComponent text, int x, int y) {
        GuiUtil.drawPanel(poseStack, x, y, font.func_238414_a_((ITextProperties)text) + 8, 16);
        font.func_243246_a(poseStack, text, (float)(x + 4), (float)(y + 4), 0xFFFFFF);
    }

    public static IFormattableTextComponent shortenText(FontRenderer font, IFormattableTextComponent text, int width) {
        if (font.func_238414_a_((ITextProperties)text) > width) {
            return new StringTextComponent(font.func_238412_a_(text.getString(), width - font.func_238414_a_((ITextProperties)ELLIPSIS))).func_230529_a_(ELLIPSIS).func_230530_a_(text.func_150256_b());
        }
        return text;
    }

    public static IFormattableTextComponent translateOrDefault(IFormattableTextComponent defaultText, String translationDesc, Object ... format) {
        if (I18n.func_188566_a((String)translationDesc)) {
            return new TranslationTextComponent(translationDesc, format);
        }
        return defaultText;
    }

    public static void playButtonClickSound() {
        GuiUtil.client().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static class Icon {
        public static final Icon SEARCH = new Icon(0, 0, 7, 8);
        public static final Icon CLOSE = new Icon(7, 0, 5, 6);
        public static final Icon REFRESH = new Icon(12, 0, 10, 10);
        public static final Icon EXPORT = new Icon(22, 0, 7, 8);
        public static final Icon EXPORT_COLORED = new Icon(29, 0, 7, 8);
        public static final Icon IMPORT = new Icon(22, 8, 7, 8);
        public static final Icon IMPORT_COLORED = new Icon(29, 8, 7, 8);
        private final int u;
        private final int v;
        private final int width;
        private final int height;

        public Icon(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }

        public void draw(MatrixStack poseStack, int x, int y) {
            RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableTexture();
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)x, (int)y, (float)this.u, (float)this.v, (int)this.width, (int)this.height, (int)256, (int)256);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

