/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shader_overrides;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkRenderShaderBackend;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ChunkRenderBackendExt;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shadows.ShadowRenderingState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkRenderShaderBackend.class})
public class MixinChunkRenderShaderBackend
implements ChunkRenderBackendExt {
    @Unique
    private IrisChunkProgramOverrides irisChunkProgramOverrides;
    @Unique
    private RenderDevice device;
    @Unique
    private ChunkProgram override;
    @Shadow(remap=false)
    protected ChunkProgram activeProgram;

    @Shadow
    public void begin(MatrixStack poseStack) {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void iris$onInit(ChunkVertexType vertexType, CallbackInfo ci) {
        this.irisChunkProgramOverrides = new IrisChunkProgramOverrides();
    }

    @Inject(method={"createShaders"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onCreateShaders(RenderDevice device, CallbackInfo ci) {
        this.device = device;
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        SodiumTerrainPipeline sodiumTerrainPipeline = null;
        if (worldRenderingPipeline != null) {
            sodiumTerrainPipeline = worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        this.irisChunkProgramOverrides.createShaders(sodiumTerrainPipeline, device);
    }

    @Override
    public void iris$begin(MatrixStack poseStack, BlockRenderPass pass) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            RenderSystem.disableCull();
        }
        this.override = this.irisChunkProgramOverrides.getProgramOverride(this.device, pass);
        Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::beginSodiumTerrainRendering);
        this.begin(poseStack);
    }

    @Inject(method={"begin"}, at={@At(value="FIELD", target="me/jellysquid/mods/sodium/client/render/chunk/shader/ChunkRenderShaderBackend.activeProgram: Lme/jellysquid/mods/sodium/client/render/chunk/shader/ChunkProgram;", args={"opcode=PUTFIELD"}, remap=false, shift=At.Shift.AFTER)})
    private void iris$applyOverride(MatrixStack poseStack, CallbackInfo ci) {
        if (this.override != null) {
            this.activeProgram = this.override;
        }
    }

    @Inject(method={"end"}, at={@At(value="RETURN")})
    private void iris$onEnd(MatrixStack poseStack, CallbackInfo ci) {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::endSodiumTerrainRendering);
    }

    @Inject(method={"delete"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onDelete(CallbackInfo ci) {
        this.irisChunkProgramOverrides.deleteShaders();
    }
}

