/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.basic;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.data.TypedTreeCache;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.function.Function;

public class CachingParser
extends EnhancedParser {
    private TypedTreeCache<ExtendedContext> parseCache;

    public CachingParser(boolean throwParseErrors, int cacheSize) {
        super(throwParseErrors);
        this.parseCache = new TypedTreeCache(cacheSize);
    }

    public CachingParser(int cacheSize) {
        this.parseCache = new TypedTreeCache(cacheSize);
    }

    public CachingParser(boolean throwParseErrors) {
        super(throwParseErrors);
        this.parseCache = new TypedTreeCache();
    }

    public CachingParser() {
        this.parseCache = new TypedTreeCache();
    }

    public void setParseCacheSizeAndClear(int size) {
        this.parseCache = new TypedTreeCache(size);
    }

    @Override
    public GLSLParser.TranslationUnitContext parse(String str) {
        return this.parse(str, GLSLParser.TranslationUnitContext.class, GLSLParser::translationUnit);
    }

    public <RuleType extends ExtendedContext> RuleType parse(String str, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod) {
        return this.parse(str, null, ruleType, parseMethod);
    }

    public <RuleType extends ExtendedContext> RuleType parse(String str, ExtendedContext parent, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod) {
        return (RuleType)this.parseCache.cachedGet(str, ruleType, () -> this.parse(str, parent, parseMethod));
    }

    @Override
    public void setParseTokenFilter(TokenFilter<?> parseTokenFilter) {
        super.setParseTokenFilter(parseTokenFilter);
        this.parseCache.clear();
    }
}

