/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class RegistryUtil {
    private final DynamicRegistries registries;

    private RegistryUtil(DynamicRegistries registries) {
        this.registries = registries;
    }

    public static RegistryUtil side(@Nonnull LogicalSide side) {
        if (side.isServer()) {
            return RegistryUtil.server();
        }
        return RegistryUtil.client();
    }

    public static RegistryUtil server() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return new RegistryUtil((DynamicRegistries)DynamicRegistries.func_239770_b_());
        }
        return new RegistryUtil(server.func_244267_aX());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RegistryUtil client() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147114_u() == null) {
            return new RegistryUtil((DynamicRegistries)DynamicRegistries.func_239770_b_());
        }
        return new RegistryUtil(mc.func_147114_u().func_239165_n_());
    }

    @Nullable
    public <V> RegistryKey<V> getRegistryKey(@Nonnull RegistryKey<Registry<V>> registry, V value) {
        return this.registries.func_243612_b(registry).func_230519_c_(value).orElse(null);
    }

    @Nullable
    public <V> ResourceLocation getKey(@Nonnull RegistryKey<Registry<V>> registry, V value) {
        return this.registries.func_243612_b(registry).func_177774_c(value);
    }

    @Nullable
    public <V> V getValue(@Nonnull RegistryKey<Registry<V>> registry, RegistryKey<V> key) {
        return (V)this.registries.func_243612_b(registry).func_230516_a_(key);
    }

    @Nullable
    public <V> V getValue(@Nonnull RegistryKey<Registry<V>> registry, ResourceLocation key) {
        return (V)this.registries.func_243612_b(registry).func_82594_a(key);
    }

    public <V> Collection<Map.Entry<RegistryKey<V>, V>> getEntries(@Nonnull RegistryKey<Registry<V>> registry) {
        return this.registries.func_243612_b(registry).func_239659_c_();
    }

    public <V> Collection<ResourceLocation> getKeys(@Nonnull RegistryKey<Registry<V>> registry) {
        return this.registries.func_243612_b(registry).func_148742_b();
    }

    public <V> Collection<V> getValues(@Nonnull RegistryKey<Registry<V>> registry) {
        return this.getEntries(registry).stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

