/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheIOThread;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class WorldCacheDomain {
    private final ResourceLocation key;
    private final Set<SaveKey<? extends CachedWorldData>> knownSaveKeys = new HashSet<SaveKey<? extends CachedWorldData>>();
    private final Map<ResourceLocation, Map<SaveKey<?>, CachedWorldData>> domainData = new HashMap();

    WorldCacheDomain(ResourceLocation key) {
        this.key = key;
    }

    public <T extends CachedWorldData> SaveKey<T> createSaveKey(String name, Function<SaveKey<T>, T> dataProvider) {
        for (SaveKey<? extends CachedWorldData> key : this.knownSaveKeys) {
            if (!((SaveKey)key).identifier.equalsIgnoreCase(name)) continue;
            return key;
        }
        SaveKey key = new SaveKey(name, dataProvider);
        this.knownSaveKeys.add(key);
        return key;
    }

    @Nullable
    public <T extends CachedWorldData> SaveKey<T> getKey(String identifier) {
        for (SaveKey<? extends CachedWorldData> key : this.knownSaveKeys) {
            if (!((SaveKey)key).identifier.equalsIgnoreCase(identifier)) continue;
            return key;
        }
        return null;
    }

    @Nonnull
    public Set<SaveKey<? extends CachedWorldData>> getKnownSaveKeys() {
        return Collections.unmodifiableSet(this.knownSaveKeys);
    }

    public ResourceLocation getName() {
        return this.key;
    }

    void tick(World world) {
        ResourceLocation dimName = world.func_234923_W_().func_240901_a_();
        if (!this.domainData.containsKey(dimName)) {
            return;
        }
        Map<SaveKey<?>, CachedWorldData> dataMap = this.domainData.get(dimName);
        for (SaveKey<? extends CachedWorldData> key : this.getKnownSaveKeys()) {
            if (!dataMap.containsKey(key)) continue;
            dataMap.get(key).updateTick(world);
        }
    }

    @Nullable
    <T extends CachedWorldData> T getCachedData(ResourceLocation dimTypeName, SaveKey<T> key) {
        return (T)((CachedWorldData)this.domainData.getOrDefault(dimTypeName, Collections.emptyMap()).get(key));
    }

    @Nullable
    private <T extends CachedWorldData> T getFromCache(World world, SaveKey<T> key) {
        return this.getCachedData(world.func_234923_W_().func_240901_a_(), key);
    }

    Collection<ResourceLocation> getUsedWorlds() {
        return this.domainData.keySet();
    }

    @Nonnull
    public <T extends CachedWorldData> T getData(World world, SaveKey<T> key) {
        T data = this.getFromCache(world, key);
        if (data == null) {
            data = WorldCacheIOThread.loadNow(this, world, key);
            this.domainData.computeIfAbsent(world.func_234923_W_().func_240901_a_(), i -> new HashMap()).put(key, data);
        }
        return data;
    }

    public File getSaveDirectory() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return null;
        }
        File dataDir = server.func_240776_a_(new FolderName(this.key.func_110624_b())).toFile();
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return dataDir;
    }

    void clear() {
        this.domainData.clear();
    }

    public static class SaveKey<T extends CachedWorldData> {
        private final String identifier;
        private final Function<SaveKey<T>, T> instanceProvider;

        private SaveKey(String identifier, Function<SaveKey<T>, T> provider) {
            this.identifier = identifier;
            this.instanceProvider = provider;
        }

        public T getNewInstance(SaveKey<T> key) {
            return (T)((CachedWorldData)this.instanceProvider.apply(key));
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

