/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.client;

import com.google.common.collect.Iterables;
import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.client.StructureRenderLightManager;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import hellfirepvp.observerlib.api.util.SingleBiomeManager;
import hellfirepvp.observerlib.client.util.ClientTickHelper;
import hellfirepvp.observerlib.common.util.RegistryUtil;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureRenderWorld
implements IWorldReader {
    private static final int MAX_LIGHT = 15;
    private final Biome globalBiome;
    private final SingleBiomeManager biomeManager;
    private final DimensionType thisDimType;
    private final WorldBorder maxBorder;
    private final Structure structure;
    private final Stack<Predicate<BlockPos>> blockFilter = new Stack();

    public StructureRenderWorld(Structure structure, Biome globalBiome) {
        this.structure = structure;
        this.globalBiome = globalBiome;
        this.biomeManager = new SingleBiomeManager(this.globalBiome);
        DimensionType dimType = (DimensionType)RegistryUtil.client().getValue(Registry.field_239698_ad_, DimensionType.field_235999_c_);
        if (dimType == null) {
            dimType = (DimensionType)Iterables.getFirst(RegistryUtil.client().getValues(Registry.field_239698_ad_), null);
        }
        this.thisDimType = dimType;
        this.maxBorder = this.thisDimType.func_242724_f() != 1.0 ? new WorldBorder(){

            public double func_230316_a_() {
                return super.func_230316_a_() / StructureRenderWorld.this.thisDimType.func_242724_f();
            }

            public double func_230317_b_() {
                return super.func_230317_b_() / StructureRenderWorld.this.thisDimType.func_242724_f();
            }
        } : new WorldBorder();
    }

    public void pushContentFilter(@Nonnull Predicate<BlockPos> blockFilter) {
        this.blockFilter.push(blockFilter);
    }

    public void popContentFilter() {
        this.blockFilter.pop();
    }

    private boolean allowAccess(BlockPos pos) {
        for (Predicate predicate : this.blockFilter) {
            if (predicate.test(pos)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (!this.structure.hasBlockAt(pos) || !this.allowAccess(pos)) {
            return null;
        }
        MatchableState state = this.structure.getBlockStateAt(pos);
        TileEntity tile = state.createTileEntity((IBlockReader)this, ClientTickHelper.getClientTick());
        if (tile == null) {
            return null;
        }
        tile.func_226984_a_((World)Minecraft.func_71410_x().field_71441_e, pos);
        MatchableTile<? extends TileEntity> tileMatch = this.structure.getTileEntityAt(pos);
        if (tileMatch == null) {
            return tile;
        }
        CompoundNBT tag = new CompoundNBT();
        tile.func_189515_b(tag);
        tileMatch.writeDisplayData((TileEntity)tile, ClientTickHelper.getClientTick(), tag);
        tile.func_230337_a_(state.getDescriptiveState(0L), tag);
        tileMatch.postPlacement((TileEntity)tile, (IBlockReader)this, pos);
        return tile;
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (!this.structure.hasBlockAt(pos) || !this.allowAccess(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        MatchableState state = this.structure.getContents().get(pos);
        return state == null ? Blocks.field_150350_a.func_176223_P() : state.getDescriptiveState(ClientTickHelper.getClientTick());
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_230487_a_(Direction direction, boolean b) {
        return 1.0f;
    }

    public WorldLightManager func_225524_e_() {
        return new StructureRenderLightManager(15);
    }

    public int func_226658_a_(LightType lightType, BlockPos blockPos) {
        return 15;
    }

    public int func_226659_b_(BlockPos pos, int amount) {
        return 15;
    }

    public int func_201572_C() {
        return 15;
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return false;
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return null;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return 0;
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return this.biomeManager;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return this.globalBiome;
    }

    public WorldBorder func_175723_af() {
        return this.maxBorder;
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return true;
    }

    public Stream<VoxelShape> func_230318_c_(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Predicate<Entity> predicate) {
        return Stream.empty();
    }

    public boolean func_201670_d() {
        return true;
    }

    public int func_181545_F() {
        return 63;
    }

    public DimensionType func_230315_m_() {
        return this.thisDimType;
    }
}

