/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import me.cortex.nvidium.gl.GlFence;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.Buffer;
import me.cortex.nvidium.gl.buffers.PersistentClientMappedBuffer;
import me.cortex.nvidium.util.SegmentedManager;
import me.cortex.nvidium.util.TickableManager;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL42;

public class UploadingBufferStream {
    private final SegmentedManager allocationArena = new SegmentedManager();
    private final PersistentClientMappedBuffer uploadBuffer;
    private final Deque<UploadFrame> frames = new ArrayDeque<UploadFrame>();
    private final LongArrayList thisFrameAllocations = new LongArrayList();
    private final Deque<UploadData> uploadList = new ArrayDeque<UploadData>();
    private final LongArrayList flushList = new LongArrayList();
    private long caddr = -1L;
    private long offset = 0L;

    public UploadingBufferStream(RenderDevice device, long size) {
        this.allocationArena.setLimit(size);
        this.uploadBuffer = device.createClientMappedBuffer(size);
        TickableManager.register(this);
    }

    public long upload(Buffer buffer, long destOffset, long size) {
        long addr;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (this.caddr == -1L || !this.allocationArena.expand(this.caddr, (int)size)) {
            this.caddr = this.allocationArena.alloc((int)size);
            if (this.caddr == -1L) {
                this.commit();
                int attempts = 10;
                while (--attempts != 0 && this.caddr == -1L) {
                    GL11.glFinish();
                    this.tick();
                    this.caddr = this.allocationArena.alloc((int)size);
                }
                if (this.caddr == -1L) {
                    throw new IllegalStateException("Could not allocate memory segment big enough for upload even after force flush");
                }
            }
            this.flushList.add(this.caddr);
            this.offset = size;
            addr = this.caddr;
        } else {
            addr = this.caddr + this.offset;
            this.offset += size;
        }
        if (this.caddr + size > this.uploadBuffer.size) {
            throw new IllegalStateException();
        }
        this.uploadList.add(new UploadData(buffer, addr, destOffset, size));
        return this.uploadBuffer.addr + addr;
    }

    public void commit() {
        LongListIterator longListIterator = this.flushList.iterator();
        while (longListIterator.hasNext()) {
            long alloc = (Long)longListIterator.next();
            ARBDirectStateAccess.glFlushMappedNamedBufferRange((int)this.uploadBuffer.getId(), (long)alloc, (long)this.allocationArena.getSize(alloc));
            this.thisFrameAllocations.add(alloc);
        }
        this.flushList.clear();
        GL42.glMemoryBarrier((int)16384);
        for (UploadData entry : this.uploadList) {
            ARBDirectStateAccess.glCopyNamedBufferSubData((int)this.uploadBuffer.getId(), (int)entry.target.getId(), (long)entry.uploadOffset, (long)entry.targetOffset, (long)entry.size);
        }
        this.uploadList.clear();
        GL42.glMemoryBarrier((int)512);
        this.caddr = -1L;
        this.offset = 0L;
    }

    public void tick() {
        this.commit();
        if (!this.thisFrameAllocations.isEmpty()) {
            this.frames.add(new UploadFrame(new GlFence(), new LongArrayList((LongList)this.thisFrameAllocations)));
            this.thisFrameAllocations.clear();
        }
        while (!this.frames.isEmpty() && this.frames.peek().fence.signaled()) {
            UploadFrame frame = this.frames.pop();
            frame.allocations.forEach(this.allocationArena::free);
            frame.fence.free();
        }
    }

    public void delete() {
        TickableManager.remove(this);
        this.uploadBuffer.delete();
        this.frames.forEach(frame -> frame.fence.free());
    }

    private record UploadData(Buffer target, long uploadOffset, long targetOffset, long size) {
    }

    private record UploadFrame(GlFence fence, LongArrayList allocations) {
    }
}

