/*
 * Decompiled with CFR 0.152.
 */
package com.thevale.notenoughtardis.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.client.models.interiordoors.IInteriorDoorRenderer;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.misc.IDoorType;

public enum EnumDoorTypes implements IDoorType
{
    SHALKA(state -> {
        switch (state) {
            case CLOSED: {
                return 0.0;
            }
            case ONE: {
                return 85.0;
            }
            case BOTH: {
                return -85.0;
            }
        }
        return 0.0;
    }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
    PTORED(state -> {
        switch (state) {
            case CLOSED: {
                return 0.0;
            }
            case ONE: {
                return 85.0;
            }
            case BOTH: {
                return -85.0;
            }
        }
        return 0.0;
    }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
    WARDROBE(state -> {
        switch (state) {
            case CLOSED: {
                return 0.0;
            }
            case ONE: {
                return -100.0;
            }
            case BOTH: {
                return 100.0;
            }
        }
        return 0.0;
    }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
    ORGAN(state -> {
        switch (state) {
            case CLOSED: {
                return 0.0;
            }
            case ONE: {
                return 45.0;
            }
            case BOTH: {
                return 90.0;
            }
        }
        return 0.0;
    }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
    CANON05(state -> {
        switch (state) {
            case CLOSED: {
                return 0.0;
            }
            case ONE: {
                return 90.0;
            }
            case BOTH: {
                return -90.0;
            }
        }
        return 0.0;
    }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH);

    Function<EnumDoorState, Double> func;
    EnumDoorState[] validStates;
    Supplier<Supplier<IInteriorDoorRenderer>> renderer;

    private EnumDoorTypes(Function<EnumDoorState, Double> func, EnumDoorState ... states) {
        this.validStates = states;
        this.func = func;
    }

    public EnumDoorState[] getValidStates() {
        return this.validStates;
    }

    public double getRotationForState(EnumDoorState state) {
        return this.func.apply(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInteriorDoorModel(IInteriorDoorRenderer renderer) {
        this.renderer = () -> () -> renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IInteriorDoorRenderer getInteriorDoorRenderer() {
        return this.renderer.get().get();
    }
}

