/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.norecipeadvancements.mixin;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.permutated.norecipeadvancements.NoRecipeAdvancements;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AdvancementManager.class})
public class MixinAdvancementManager {
    @Final
    @Shadow
    private static Logger field_192782_a;
    @Shadow
    private AdvancementList field_223388_c;
    @Final
    @Shadow
    private LootPredicateManager field_240922_d_;

    @Overwrite
    protected void func_212853_a_(Map<ResourceLocation, JsonElement> datapacks, IResourceManager resourceManager, IProfiler profiler) {
        HashMap map = Maps.newHashMap();
        AtomicInteger recipeAdvancements = new AtomicInteger();
        datapacks.forEach((location, jsonElement) -> {
            try {
                JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonElement, (String)"advancement");
                Advancement.Builder advancement$builder = Advancement.Builder.func_241043_a_((JsonObject)jsonobject, (ConditionArrayParser)new ConditionArrayParser(location, this.field_240922_d_));
                if (advancement$builder == null) {
                    field_192782_a.debug("Skipping loading advancement {} as it's conditions were not met", location);
                    return;
                }
                if (advancement$builder.func_200277_c().containsKey("has_the_recipe")) {
                    recipeAdvancements.incrementAndGet();
                    return;
                }
                map.put(location, advancement$builder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", location, (Object)jsonparseexception.getMessage());
            }
        });
        AdvancementList advancementlist = new AdvancementList();
        advancementlist.func_192083_a((Map)map);
        NoRecipeAdvancements.LOGGER.info("Skipped loading {} recipe advancements.", (Object)recipeAdvancements.get());
        for (Advancement advancement : advancementlist.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a((Advancement)advancement);
        }
        this.field_223388_c = advancementlist;
    }
}

