/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.gui.TransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISortingCategory;
import com.chaosthedude.naturescompass.sorting.NameCategory;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NaturesCompassScreen
extends Screen {
    public World world;
    private PlayerEntity player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private NaturesCompassItem natureCompass;
    private Button startSearchButton;
    private Button teleportButton;
    private Button infoButton;
    private Button cancelButton;
    private Button sortByButton;
    private TransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISortingCategory sortingCategory;

    public NaturesCompassScreen(World world, PlayerEntity player, ItemStack stack, NaturesCompassItem natureCompass, List<ResourceLocation> allowedBiomes) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0])));
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = new ArrayList<Biome>();
        this.loadAllowedBiomes(allowedBiomes);
        this.sortingCategory = new NameCategory();
        this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
    }

    public boolean func_231043_a_(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.func_231043_a_(scroll1, scroll2, scroll3);
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.field_230706_i_, this.field_230708_k_ + 110, this.field_230709_l_, 40, this.field_230709_l_, 45);
        }
        this.field_230705_e_.add(this.selectionList);
    }

    public void func_231023_e_() {
        this.searchTextField.func_146178_a();
        boolean bl = this.teleportButton.field_230693_o_ = this.natureCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedBiomes.size() != NaturesCompass.allowedBiomes.size()) {
            this.field_230705_e_.remove((Object)this.selectionList);
            this.loadAllowedBiomes(NaturesCompass.allowedBiomes);
            this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
            this.selectionList = new BiomeSearchList(this, this.field_230706_i_, this.field_230708_k_ + 110, this.field_230709_l_, 40, this.field_230709_l_, 45);
            this.field_230705_e_.add(this.selectionList);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.selectionList.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        NaturesCompassScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), (int)65, (int)15, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        boolean ret = super.func_231046_a_(par1, par2, par3);
        if (this.searchTextField.func_230999_j_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        boolean ret = super.func_231042_a_(typedChar, keyCode);
        if (this.searchTextField.func_230999_j_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.field_230693_o_ = enable = entry != null;
        this.infoButton.field_230693_o_ = enable;
    }

    public void searchForBiome(Biome biome) {
        NaturesCompass.network.sendToServer((Object)new CompassSearchPacket(BiomeUtils.getKeyForBiome(this.world, biome), this.player.func_233580_cy_()));
        this.field_230706_i_.func_147108_a(null);
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((Object)new TeleportPacket());
        this.field_230706_i_.func_147108_a(null);
    }

    public ISortingCategory getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        for (Biome biome : this.allowedBiomes) {
            if (!BiomeUtils.getBiomeNameForDisplay(this.world, biome).toLowerCase().contains(this.searchTextField.func_146179_b().toLowerCase())) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameCategory());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupButtons() {
        this.field_230710_m_.clear();
        this.cancelButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), onPress -> this.field_230706_i_.func_147108_a(null)));
        this.sortByButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, 90, 110, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.func_238482_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()));
            this.selectionList.refreshList();
        }));
        this.infoButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, 65, 110, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.info"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.func_230958_g_()).viewInfo();
            }
        }));
        this.startSearchButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, 40, 110, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.func_230958_g_()).searchForBiome();
            }
        }));
        this.teleportButton = (Button)this.func_230480_a_((Widget)new TransparentButton(this.field_230708_k_ - 120, 10, 110, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.field_230693_o_ = false;
        this.infoButton.field_230693_o_ = false;
        this.teleportButton.field_230694_p_ = NaturesCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new TransparentTextField(this.field_230712_o_, 130, 10, 140, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.search"));
        this.field_230705_e_.add(this.searchTextField);
    }

    private void loadAllowedBiomes(List<ResourceLocation> allowedBiomeKeys) {
        this.allowedBiomes = new ArrayList<Biome>();
        for (ResourceLocation biomeKey : allowedBiomeKeys) {
            Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey(this.world, biomeKey);
            if (!optionalBiome.isPresent()) continue;
            this.allowedBiomes.add(optionalBiome.get());
        }
    }
}

