/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.compat.Compat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class PlayerLayerTrinkets
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final Set<Item> alreadyRendered = new HashSet<Item>();

    public PlayerLayerTrinkets(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)ModConfig.instance.renderItemsOnPlayer.get()).booleanValue()) {
            return;
        }
        if (player.func_70660_b(Effects.field_76441_p) != null) {
            return;
        }
        ItemStack main = player.func_184614_ca();
        ItemStack second = player.func_184592_cb();
        this.alreadyRendered.clear();
        matrixStackIn.func_227860_a_();
        this.render((PlayerEntity)player, ITrinketItem.RenderType.BODY, main, second, matrixStackIn, bufferIn, packedLightIn);
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(yawOffset));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw - 270.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(pitch));
        this.render((PlayerEntity)player, ITrinketItem.RenderType.HEAD, main, second, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private void render(PlayerEntity player, ITrinketItem.RenderType type, ItemStack main, ItemStack second, MatrixStack matrices, IRenderTypeBuffer buffer, int packedLight) {
        IItemHandler handler;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            this.renderStack(player.field_71071_by.func_70301_a(i), player, type, main, second, matrices, buffer, packedLight);
        }
        if (Compat.hasCompat("curios") && (handler = (IItemHandler)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).orElse(null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.renderStack(handler.getStackInSlot(i), player, type, main, second, matrices, buffer, packedLight);
            }
        }
    }

    private void renderStack(ItemStack stack, PlayerEntity player, ITrinketItem.RenderType type, ItemStack main, ItemStack second, MatrixStack matrices, IRenderTypeBuffer buffer, int packedLight) {
        Item item;
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ITrinketItem && !this.alreadyRendered.contains(item)) {
            matrices.func_227860_a_();
            if (type == ITrinketItem.RenderType.BODY && player.func_213283_Z() == Pose.CROUCHING) {
                matrices.func_227861_a_(0.0, (double)0.2f, 0.0);
                matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(28.647888f));
            }
            ((ITrinketItem)item).render(stack, player, type, matrices, buffer, packedLight, stack == main || stack == second);
            matrices.func_227865_b_();
            this.alreadyRendered.add(item);
        }
    }
}

