/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import com.mojang.serialization.Codec;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class WorldGenAncientTree
extends Feature<BaseTreeFeatureConfig> {
    public static final BaseTreeFeatureConfig CONFIG = new BaseTreeFeatureConfig.Builder(null, null, null, null, null).func_225568_b_();

    public WorldGenAncientTree() {
        super(Codec.unit((Object)CONFIG));
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig p_241855_5_) {
        int height = rand.nextInt(3) + 5;
        BlockPos trunkTop = pos.func_177981_b(height);
        this.func_230367_a_((IWorldWriter)world, pos, Blocks.field_150350_a.func_176223_P());
        int rootsAmount = rand.nextInt(4) + 5;
        for (int i = 0; i < rootsAmount; ++i) {
            int length = rand.nextInt(3) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)rootsAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = pos.func_177963_a((double)x, 0.0, (double)z);
            while (world.func_217375_a(goal, state -> state.func_185904_a().func_76222_j()) && !((goal = goal.func_177977_b()).func_177951_i((Vector3i)pos) >= 100.0)) {
            }
            this.makeBranch(world, pos.func_177981_b(rand.nextInt(1)), goal, ModBlocks.ANCIENT_BARK.func_176223_P(), false);
        }
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                for (int i = height - (x + z) * (rand.nextInt(2) + 2); i >= 0; --i) {
                    BlockPos goal = pos.func_177982_a(x, i, z);
                    if (world.func_217375_a(goal, s -> !s.canBeReplacedByLogs((IWorldReader)world, goal))) continue;
                    this.func_230367_a_((IWorldWriter)world, goal, (BlockState)ModBlocks.ANCIENT_LOG.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
            }
        }
        this.makeLeaves((IWorldGenerationReader)world, trunkTop.func_177981_b(rand.nextInt(2) - 1), ModBlocks.ANCIENT_LEAVES.func_176223_P(), rand.nextInt(2) + 3, rand);
        int branchAmount = rand.nextInt(3) + 4;
        for (int i = 0; i < branchAmount; ++i) {
            int length = rand.nextInt(2) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)branchAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = trunkTop.func_177963_a((double)x, (double)(rand.nextInt(3) + 1), (double)z);
            this.makeBranch(world, trunkTop, goal, ModBlocks.ANCIENT_LOG.func_176223_P(), true);
            this.makeLeaves((IWorldGenerationReader)world, goal, ModBlocks.ANCIENT_LEAVES.func_176223_P(), rand.nextInt(2) + 2, rand);
        }
        return true;
    }

    private void makeBranch(ISeedReader world, BlockPos first, BlockPos second, BlockState state, boolean hasAxis) {
        BlockPos pos = second.func_177982_a(-first.func_177958_n(), -first.func_177956_o(), -first.func_177952_p());
        int length = this.getHighestCoord(pos);
        float stepX = (float)pos.func_177958_n() / (float)length;
        float stepY = (float)pos.func_177956_o() / (float)length;
        float stepZ = (float)pos.func_177952_p() / (float)length;
        for (int i = 0; i <= length; ++i) {
            BlockPos goal = first.func_177963_a((double)(0.5f + (float)i * stepX), (double)(0.5f + (float)i * stepY), (double)(0.5f + (float)i * stepZ));
            if (world.func_217375_a(goal, s -> !s.canBeReplacedByLogs((IWorldReader)world, goal))) continue;
            if (hasAxis) {
                Direction.Axis axis = this.getLogAxis(first, goal);
                this.func_230367_a_((IWorldWriter)world, goal, (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis));
                continue;
            }
            this.func_230367_a_((IWorldWriter)world, goal, state);
        }
    }

    private void makeLeaves(IWorldGenerationReader world, BlockPos pos, BlockState state, int radius, Random rand) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos goal = pos.func_177982_a(x, y, z);
                    if (!(pos.func_177951_i((Vector3i)goal) <= (double)(radius * radius + rand.nextInt(3) - 1)) || world.func_217375_a(goal, s -> s.func_185904_a() == Material.field_151584_j) || !world.func_217375_a(goal, st -> {
                        Block block = st.func_177230_c();
                        return st.func_185904_a() != Material.field_151575_d && block != Blocks.field_150346_d && block != Blocks.field_150349_c;
                    })) continue;
                    this.func_230367_a_((IWorldWriter)world, goal, state);
                }
            }
        }
    }

    private int getHighestCoord(BlockPos pos) {
        return Math.max(MathHelper.func_76130_a((int)pos.func_177958_n()), Math.max(MathHelper.func_76130_a((int)pos.func_177956_o()), MathHelper.func_76130_a((int)pos.func_177952_p())));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos goal) {
        int y;
        Direction.Axis axis = Direction.Axis.Y;
        int x = Math.abs(goal.func_177958_n() - pos.func_177958_n());
        int highest = Math.max(x, y = Math.abs(goal.func_177952_p() - pos.func_177952_p()));
        if (highest > 0) {
            if (x == highest) {
                axis = Direction.Axis.X;
            } else if (y == highest) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }
}

