/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class TileEntityChunkLoader
extends TileEntityImpl
implements ITickableTileEntity {
    private final List<ChunkPos> forcedChunks = new ArrayList<ChunkPos>();
    private boolean firstTick = true;

    public TileEntityChunkLoader() {
        super(ModTileEntities.CHUNK_LOADER);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.loadChunks(true);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        if (!this.field_145850_b.field_72995_K) {
            this.loadChunks(false);
            this.sendToClients();
        }
    }

    public int range() {
        return this.redstonePower * 2;
    }

    private void loadChunks(boolean unload) {
        int range;
        if (this.field_145850_b.field_72995_K || !((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue()) {
            return;
        }
        ServerWorld world = (ServerWorld)this.field_145850_b;
        ArrayList<ChunkPos> shouldBeForced = new ArrayList<ChunkPos>();
        if (!unload && (range = this.range()) > 0) {
            for (int x = this.field_174879_c.func_177958_n() - range >> 4; x <= this.field_174879_c.func_177958_n() + range >> 4; ++x) {
                for (int z = this.field_174879_c.func_177952_p() - range >> 4; z <= this.field_174879_c.func_177952_p() + range >> 4; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    if (!this.forcedChunks.contains(pos) && world.func_217469_z().contains(pos.func_201841_a())) continue;
                    shouldBeForced.add(pos);
                }
            }
        }
        for (ChunkPos pos : this.forcedChunks) {
            if (shouldBeForced.contains(pos)) continue;
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, false);
        }
        this.forcedChunks.clear();
        for (ChunkPos pos : shouldBeForced) {
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
            this.forcedChunks.add(pos);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue()) {
            if (this.firstTick) {
                this.loadChunks(false);
                this.firstTick = false;
            }
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            int toUse = MathHelper.func_76123_f((float)((float)this.range() / 2.0f));
            if (toUse > 0) {
                BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).drainAura(spot, toUse);
            }
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            compound.func_202168_c("forced_chunks", this.forcedChunks.stream().map(ChunkPos::func_201841_a).collect(Collectors.toList()));
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            this.forcedChunks.clear();
            Arrays.stream(compound.func_197645_o("forced_chunks")).mapToObj(ChunkPos::new).forEach(this.forcedChunks::add);
        }
    }
}

