/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityFieldCreator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockFieldCreator
extends BlockContainerImpl
implements ICustomBlockState,
ICustomRenderType {
    public BlockFieldCreator() {
        super("field_creator", TileEntityFieldCreator::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f).func_226896_b_().func_200947_a(SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFieldCreator) {
            if (!worldIn.field_72995_K) {
                String key = "naturesaura:field_creator_pos";
                CompoundNBT compound = player.getPersistentData();
                if (!player.func_225608_bj_() && compound.func_74764_b(key)) {
                    BlockPos stored = BlockPos.func_218283_e((long)compound.func_74763_f(key));
                    TileEntityFieldCreator creator = (TileEntityFieldCreator)tile;
                    if (!pos.equals((Object)stored)) {
                        if (creator.isCloseEnough(stored)) {
                            TileEntity otherTile = worldIn.func_175625_s(stored);
                            if (otherTile instanceof TileEntityFieldCreator) {
                                creator.connectionOffset = stored.func_177973_b((Vector3i)pos);
                                creator.isMain = true;
                                creator.sendToClients();
                                TileEntityFieldCreator otherCreator = (TileEntityFieldCreator)otherTile;
                                otherCreator.connectionOffset = pos.func_177973_b((Vector3i)stored);
                                otherCreator.isMain = false;
                                otherCreator.sendToClients();
                                compound.func_82580_o(key);
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.connected"), true);
                            } else {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.stored_pos_gone"), true);
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.too_far"), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.same_position"), true);
                    }
                } else {
                    compound.func_74772_a(key, pos.func_218275_a());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.stored_pos"), true);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFieldCreator) {
            BlockPos connected;
            TileEntityFieldCreator creator = (TileEntityFieldCreator)tile;
            if (creator.isCharged && (connected = creator.getConnectedPos()) != null) {
                NaturesAuraAPI.instance().spawnParticleStream((float)pos.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, 0.65f, 4343284, 1.0f);
            }
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::func_228641_d_;
    }
}

