/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CropCreator {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");

    public static ICrop create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        String tierId = JSONUtils.func_151200_h((JsonObject)json, (String)"tier");
        String typeId = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        CropTier tier = MysticalAgricultureAPI.getCropTierById((ResourceLocation)new ResourceLocation(tierId));
        if (tier == null) {
            throw new JsonSyntaxException("Invalid crop tier provided: " + tierId);
        }
        CropType type = MysticalAgricultureAPI.getCropTypeByName((String)typeId);
        if (type == null) {
            throw new JsonSyntaxException("Invalid crop type provided: " + typeId);
        }
        JsonObject ingredient = json.has("ingredient") ? JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient") : null;
        LazyIngredient material = LazyIngredient.EMPTY;
        if (ingredient != null) {
            if (ingredient.has("tag")) {
                String tag = JSONUtils.func_151200_h((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = JSONUtils.func_151200_h((JsonObject)ingredient, (String)"item");
                if (ingredient.has("nbt")) {
                    CompoundNBT nbt = ParsingUtils.parseNBT(ingredient.get("nbt"));
                    material = LazyIngredient.item((String)item, (CompoundNBT)nbt);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
        }
        Crop crop = new Crop(id, tier, type, material);
        if (json.has("color")) {
            String color = JSONUtils.func_151200_h((JsonObject)json, (String)"color");
            int i = ParsingUtils.parseHex(color, "color");
            crop.setColor(i);
        } else if (json.has("colors")) {
            int i;
            String color;
            JsonObject colors = JSONUtils.func_152754_s((JsonObject)json, (String)"colors");
            if (colors.has("flower")) {
                color = JSONUtils.func_151200_h((JsonObject)colors, (String)"flower");
                i = ParsingUtils.parseHex(color, "flower");
                crop.setFlowerColor(i);
            }
            if (colors.has("essence")) {
                color = JSONUtils.func_151200_h((JsonObject)colors, (String)"essence");
                i = ParsingUtils.parseHex(color, "essence");
                crop.setEssenceColor(i);
            }
            if (colors.has("seeds")) {
                color = JSONUtils.func_151200_h((JsonObject)colors, (String)"seeds");
                i = ParsingUtils.parseHex(color, "seeds");
                crop.setSeedColor(i);
            }
        }
        CropTextures ctextures = crop.getTextures().setFlowerTexture(CropTextures.FLOWER_INGOT_BLANK).setEssenceTexture(CropTextures.ESSENCE_INGOT_BLANK).setSeedTexture(CropTextures.SEED_BLANK);
        if (json.has("textures")) {
            ResourceLocation location;
            JsonObject textures = JSONUtils.func_152754_s((JsonObject)json, (String)"textures");
            if (textures.has("flower")) {
                String texture = JSONUtils.func_151200_h((JsonObject)textures, (String)"flower");
                location = new ResourceLocation(texture);
                ctextures.setFlowerTexture(location);
            }
            if (textures.has("essence")) {
                String texture = JSONUtils.func_151200_h((JsonObject)textures, (String)"essence");
                location = new ResourceLocation(texture);
                ctextures.setEssenceTexture(location);
            }
            if (textures.has("seeds")) {
                String texture = JSONUtils.func_151200_h((JsonObject)textures, (String)"seeds");
                location = new ResourceLocation(texture);
                ctextures.setSeedTexture(location);
            }
        }
        if (json.has("name")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            crop.setDisplayName((ITextComponent)new StringTextComponent(name));
        }
        if (json.has("enabled")) {
            boolean enabled = JSONUtils.func_151212_i((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            String crux = JSONUtils.func_151200_h((JsonObject)json, (String)"crux");
            CropLoader.CRUX_MAP.put((ICrop)crop, new ResourceLocation(crux));
        }
        if (json.has("glint")) {
            boolean glint = JSONUtils.func_151212_i((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = JSONUtils.func_151214_t((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(new ResourceLocation(biome.getAsString())));
        }
        if (CropCreator.isGarbageSeed(crop.getName())) {
            RegistryObject essence = RegistryObject.of((ResourceLocation)new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("essence")), (IForgeRegistry)ForgeRegistries.ITEMS);
            essence.updateReference(ForgeRegistries.ITEMS);
            if (essence.isPresent()) {
                crop.setEssence((Supplier)essence);
            } else {
                LOGGER.error("Could not find the essence for crop {}", (Object)crop.getId());
            }
        }
        return crop;
    }

    private static boolean isGarbageSeed(String name) {
        return "prudentium".equals(name) || "tertium".equals(name) || "imperium".equals(name) || "supremium".equals(name) || "fertilized".equals(name);
    }
}

