/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;

public class ElevatorGroupRenderer {
    public static final double RENDER_DISTANCE = 260100.0;
    public static boolean isIrisRenderingShadows = false;

    public static void registerEventListeners() {
        RenderWorldEvent.EVENT.register(ElevatorGroupRenderer::onRender);
    }

    public static void onRender(RenderWorldEvent e) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        e.getPoseStack().method_22903();
        class_243 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        for (ElevatorGroup group : groups.getGroups()) {
            class_2338 elevatorPos = new class_2338(group.x, (int)group.getCurrentY(), group.z);
            if (!(elevatorPos.method_10262((class_2382)ClientUtils.getPlayer().method_24515()) < 260100.0) || !ClientUtils.getMinecraft().method_1561().method_3958()) continue;
            ElevatorGroupRenderer.renderGroupCageOutlines(e.getPoseStack(), group);
        }
        e.getPoseStack().method_22909();
    }

    public static void renderBlocks(class_4587 poseStack, class_1921 renderType, class_4597 bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        class_4588 buffer = bufferSource.getBuffer(renderType);
        poseStack.method_22903();
        class_243 camera = RenderUtils.getCameraPosition();
        poseStack.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        for (ElevatorGroup group : groups.getGroups()) {
            class_2338 elevatorPos;
            if (!group.isMoving() || !((elevatorPos = new class_2338(group.x, (int)group.getCurrentY(), group.z)).method_10262((class_2382)ClientUtils.getPlayer().method_24515()) < 260100.0)) continue;
            ElevatorGroupRenderer.renderGroupBlocks(poseStack, group, renderType, buffer, ClientUtils.getPartialTicks());
        }
        poseStack.method_22909();
    }

    public static void renderBlockEntities(class_4587 poseStack, float partialTicks, class_4597 bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.method_22903();
        class_243 camera = RenderUtils.getCameraPosition();
        poseStack.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        for (ElevatorGroup group : groups.getGroups()) {
            class_2338 elevatorPos;
            if (!group.isMoving() || !((elevatorPos = new class_2338(group.x, (int)group.getCurrentY(), group.z)).method_10262((class_2382)ClientUtils.getPlayer().method_24515()) < 260100.0)) continue;
            ElevatorGroupRenderer.renderGroupBlockEntities(poseStack, group, bufferSource, partialTicks);
        }
        poseStack.method_22909();
    }

    public static void renderGroupBlocks(class_4587 poseStack, ElevatorGroup group, class_1921 renderType, class_4588 buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        class_243 startPos = group.getCageAnchorPos(renderY);
        class_2338 anchorPos = new class_2338((int)startPos.field_1352, (int)startPos.field_1351, (int)startPos.field_1350);
        cage.loadRenderInfo(anchorPos, group);
        class_1937 level = ClientElevatorCage.getFakeLevel();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    poseStack.method_22903();
                    poseStack.method_22904(startPos.field_1352 + (double)x, startPos.field_1351 + (double)y, startPos.field_1350 + (double)z);
                    class_2680 state = cage.blockStates[x][y][z];
                    if (state.method_26217() == class_2464.field_11458 && class_4696.method_23679((class_2680)state) == renderType) {
                        pos.method_10103(anchorPos.method_10263() + x, anchorPos.method_10264() + y, anchorPos.method_10260() + z);
                        ClientUtils.getBlockRenderer().method_3355(state, (class_2338)pos, (class_1920)level, poseStack, buffer, true, level.field_9229);
                    }
                    poseStack.method_22909();
                }
            }
        }
    }

    public static void renderGroupBlockEntities(class_4587 poseStack, ElevatorGroup group, class_4597 buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        class_243 startPos = group.getCageAnchorPos(renderY);
        class_2338 anchorPos = new class_2338((int)startPos.field_1352, (int)startPos.field_1351, (int)startPos.field_1350);
        cage.loadRenderInfo(anchorPos, group);
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockEntities[x][y][z] == null) continue;
                    poseStack.method_22903();
                    poseStack.method_22904(startPos.field_1352 + (double)x, startPos.field_1351 + (double)y, startPos.field_1350 + (double)z);
                    class_2586 entity = cage.blockEntities[x][y][z];
                    ClientUtils.getMinecraft().method_31975().method_3555(entity, partialTicks, poseStack, buffer);
                    poseStack.method_22909();
                }
            }
        }
    }

    public static void renderGroupCageOutlines(class_4587 poseStack, ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            class_2338 anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            class_238 cageArea = new class_238(anchorPos, anchorPos.method_10069(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ()));
            cageArea.method_1014(0.01);
            RenderUtils.renderBox((class_4587)poseStack, (class_238)cageArea, (float)1.0f, (float)1.0f, (float)1.0f, (boolean)true);
        }
        if (group.isMoving()) {
            ElevatorCage cage = group.getCage();
            double lastY = group.getLastY();
            double currentY = group.getCurrentY();
            double renderY = lastY + (currentY - lastY) * (double)ClientUtils.getPartialTicks();
            class_243 startPos = group.getCageAnchorPos(renderY);
            RenderUtils.renderBox((class_4587)poseStack, (class_238)new class_238(startPos, startPos.method_1031((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f, (boolean)true);
            RenderUtils.renderShape((class_4587)poseStack, (class_265)cage.shape.method_1096(startPos.field_1352, startPos.field_1351, startPos.field_1350), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f, (boolean)true);
        }
    }
}

