/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.extensions.MovingElevatorsLevel;
import com.supermartijn642.movingelevators.packets.PacketAddElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketRemoveElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketUpdateElevatorGroups;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ElevatorGroupCapability {
    private final class_1937 level;
    private final Map<ElevatorGroupPosition, ElevatorGroup> groups = new HashMap<ElevatorGroupPosition, ElevatorGroup>();

    public static ElevatorGroupCapability get(class_1937 level) {
        return ((MovingElevatorsLevel)level).getElevatorGroupCapability();
    }

    public static void registerEventListeners() {
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ClientTickEvents.END_WORLD_TICK.register(ElevatorGroupCapability::tickWorldCapability);
        }
        ServerTickEvents.END_WORLD_TICK.register(ElevatorGroupCapability::tickWorldCapability);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> ElevatorGroupCapability.onJoinWorld((class_1657)player, (class_1937)destination));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ElevatorGroupCapability.onJoin((class_1657)handler.method_32311()));
    }

    public static void tickWorldCapability(class_1937 level) {
        ElevatorGroupCapability.get(level).tick();
    }

    public static void onJoinWorld(class_1657 player, class_1937 level) {
        MovingElevators.CHANNEL.sendToPlayer(player, (BasePacket)new PacketUpdateElevatorGroups(ElevatorGroupCapability.get(level).write()));
    }

    public static void onJoin(class_1657 player) {
        MovingElevators.CHANNEL.sendToPlayer(player, (BasePacket)new PacketUpdateElevatorGroups(ElevatorGroupCapability.get(player.method_37908()).write()));
    }

    public ElevatorGroupCapability(class_1937 level) {
        this.level = level;
    }

    public ElevatorGroupCapability() {
        this.level = null;
    }

    public ElevatorGroup get(int x, int z, class_2350 facing) {
        return this.groups.get(new ElevatorGroupPosition(x, z, facing));
    }

    public void add(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.method_11016(), controller.getFacing());
        this.groups.putIfAbsent(pos, new ElevatorGroup(this.level, pos.x, pos.z, pos.facing));
        this.groups.get(pos).add(controller);
    }

    public void remove(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.method_11016(), controller.getFacing());
        ElevatorGroup group = this.groups.get(pos);
        group.remove(controller);
        if (group.getFloorCount() == 0) {
            this.groups.remove(pos);
            MovingElevators.CHANNEL.sendToDimension(this.level.method_27983(), (BasePacket)new PacketRemoveElevatorGroup(group));
        }
    }

    public void tick() {
        for (ElevatorGroup group : this.groups.values()) {
            group.update();
        }
    }

    public void updateGroup(ElevatorGroup group) {
        if (!this.level.field_9236 && group != null) {
            MovingElevators.CHANNEL.sendToDimension(this.level.method_27983(), (BasePacket)new PacketAddElevatorGroup(this.writeGroup(group)));
        }
    }

    public void removeGroup(int x, int z, class_2350 facing) {
        if (this.level.field_9236) {
            this.groups.remove(new ElevatorGroupPosition(x, z, facing));
        }
    }

    public ElevatorGroup getGroup(ControllerBlockEntity entity) {
        return this.groups.get(new ElevatorGroupPosition(entity.method_11016().method_10263(), entity.method_11016().method_10260(), entity.getFacing()));
    }

    public Collection<ElevatorGroup> getGroups() {
        return this.groups.values();
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        for (Map.Entry<ElevatorGroupPosition, ElevatorGroup> entry : this.groups.entrySet()) {
            class_2487 groupTag = new class_2487();
            groupTag.method_10566("group", (class_2520)entry.getValue().write());
            groupTag.method_10566("pos", (class_2520)entry.getKey().write());
            compound.method_10566(entry.getKey().x + ";" + entry.getKey().z, (class_2520)groupTag);
        }
        return compound;
    }

    public void read(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            this.groups.clear();
            for (String key : compound.method_10541()) {
                class_2487 groupTag = compound.method_10562(key);
                if (!groupTag.method_10545("group") || !groupTag.method_10545("pos")) continue;
                ElevatorGroupPosition pos = ElevatorGroupPosition.read(groupTag.method_10562("pos"));
                ElevatorGroup group = new ElevatorGroup(this.level, pos.x, pos.z, pos.facing);
                group.read(groupTag.method_10562("group"));
                this.groups.put(pos, group);
            }
        }
    }

    private class_2487 writeGroup(ElevatorGroup group) {
        class_2487 tag = new class_2487();
        tag.method_10566("group", (class_2520)group.write());
        tag.method_10566("pos", (class_2520)new ElevatorGroupPosition(group.x, group.z, group.facing).write());
        return tag;
    }

    public void readGroup(class_2487 tag) {
        if (tag.method_10545("group") && tag.method_10545("pos")) {
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(tag.method_10562("pos"));
            ElevatorGroup group = new ElevatorGroup(this.level, pos.x, pos.z, pos.facing);
            group.read(tag.method_10562("group"));
            this.groups.put(pos, group);
        }
    }

    private static class ElevatorGroupPosition {
        public final int x;
        public final int z;
        public final class_2350 facing;

        private ElevatorGroupPosition(int x, int z, class_2350 facing) {
            this.x = x;
            this.z = z;
            this.facing = facing;
        }

        public ElevatorGroupPosition(class_2338 pos, class_2350 facing) {
            this(pos.method_10263(), pos.method_10260(), facing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElevatorGroupPosition that = (ElevatorGroupPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.z != that.z) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10569("x", this.x);
            tag.method_10569("z", this.z);
            tag.method_10569("facing", this.facing.method_10161());
            return tag;
        }

        public static ElevatorGroupPosition read(class_2487 tag) {
            return new ElevatorGroupPosition(tag.method_10550("x"), tag.method_10550("z"), class_2350.method_10139((int)tag.method_10550("facing")));
        }
    }
}

