/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.VillagerUtils;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_3853;

public class WandererTradingEventJS
extends EventJS {
    private final Int2ObjectMap<List<class_3853.class_1652>> trades;

    public WandererTradingEventJS(Int2ObjectMap<List<class_3853.class_1652>> trades) {
        this.trades = trades;
    }

    public List<class_3853.class_1652> getTrades(int level) {
        this.checkLevel(level);
        return (List)this.trades.computeIfAbsent(level, $ -> new ArrayList());
    }

    public SimpleTrade addTrade(int level, TradeItem[] inputs, TradeItem output) {
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Sell item cannot be empty");
        Preconditions.checkArgument((inputs.length != 0 ? 1 : 0) != 0, (Object)"Buyer items cannot be empty");
        Preconditions.checkArgument((boolean)Arrays.stream(inputs).noneMatch(TradeItem::isEmpty), (Object)"Buyer items cannot be empty");
        SimpleTrade trade = VillagerUtils.createSimpleTrade(inputs, output);
        return this.addTrade(level, trade);
    }

    public <T extends class_3853.class_1652> T addTrade(int level, T trade) {
        Objects.requireNonNull(trade);
        this.getTrades(level).add(trade);
        return trade;
    }

    public void addCustomTrade(int level, TransformableTrade.Transformer transformer) {
        this.getTrades(level).add(new CustomTrade(transformer));
    }

    public void removeTrades(TradeFilter filter) {
        this.trades.forEach((level, listings) -> {
            filter.onMatch((first, second, output) -> ConsoleJS.SERVER.info((Object)("Removing wanderer trade for level " + level + ": " + first + " & " + second + " -> " + output)));
            if (!filter.matchMerchantLevel((int)level)) {
                return;
            }
            listings.removeIf(itemListing -> {
                if (itemListing instanceof TradeFilter.Filterable) {
                    TradeFilter.Filterable filterable = (TradeFilter.Filterable)itemListing;
                    return filterable.matchesTradeFilter(filter);
                }
                return false;
            });
        });
    }

    public void removeVanillaTrades(int level) {
        this.checkLevel(level);
        this.getTrades(level).removeIf(VillagerUtils::isVanillaTrade);
    }

    public void removeModdedTrades(int level) {
        this.checkLevel(level);
        this.getTrades(level).removeIf(VillagerUtils::isModdedTrade);
    }

    private void checkLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 2 ? 1 : 0) != 0, (Object)"Level must be between 1 and 2");
    }
}

