/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.EnchantedItemTrade;
import com.almostreliable.morejs.features.villager.trades.MapPosInfo;
import com.almostreliable.morejs.features.villager.trades.PotionTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.StewTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.features.villager.trades.TreasureMapTrade;
import com.almostreliable.morejs.util.WeightedList;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_7923;

public class VillagerUtils {
    public static final Map<class_3852, List<class_3853.class_1652>> CACHED_PROFESSION_TRADES = new HashMap<class_3852, List<class_3853.class_1652>>();
    public static final Set<Class<? extends class_3853.class_1652>> VANILLA_TRADE_TYPES = Set.of(class_3853.class_4160.class, class_3853.class_1648.class, class_3853.class_4163.class, class_3853.class_4165.class, class_3853.class_4164.class, class_3853.class_4161.class, class_3853.class_4167.class, class_3853.class_4166.class, class_3853.class_1654.class);

    public static boolean isVanillaTrade(class_3853.class_1652 listing) {
        return VANILLA_TRADE_TYPES.contains(listing.getClass());
    }

    public static boolean isModdedTrade(class_3853.class_1652 listing) {
        return !VillagerUtils.isVanillaTrade(listing) && !VillagerUtils.isMoreJSTrade(listing);
    }

    public static boolean isMoreJSTrade(class_3853.class_1652 listing) {
        return listing instanceof TransformableTrade || listing instanceof CustomTrade;
    }

    public static Collection<class_3852> getProfessions() {
        return class_7923.field_41195.method_10220().filter(p -> !p.comp_818().equals("none")).toList();
    }

    public static class_3852 getProfession(class_2960 id) {
        class_3852 villagerProfession = (class_3852)class_7923.field_41195.method_10223(id);
        if (villagerProfession == class_3852.field_17051) {
            throw new IllegalStateException("No profession with id " + id);
        }
        return villagerProfession;
    }

    public static SimpleTrade createSimpleTrade(TradeItem[] inputs, TradeItem output) {
        return new SimpleTrade(inputs, output);
    }

    public static CustomTrade createCustomTrade(TransformableTrade.Transformer transformer) {
        return new CustomTrade(transformer);
    }

    public static TreasureMapTrade createStructureMapTrade(TradeItem[] inputs, WeightedList<Object> structures) {
        return TreasureMapTrade.forStructure(inputs, structures);
    }

    public static TreasureMapTrade createBiomeMapTrade(TradeItem[] inputs, WeightedList<Object> biomes) {
        return TreasureMapTrade.forBiome(inputs, biomes);
    }

    public static TreasureMapTrade createCustomMapTrade(TradeItem[] inputs, MapPosInfo.Provider func) {
        return new TreasureMapTrade(inputs, func);
    }

    public static EnchantedItemTrade createEnchantedItemTrade(TradeItem[] inputs, class_1792 output) {
        return new EnchantedItemTrade(inputs, output);
    }

    public static StewTrade createStewTrade(TradeItem[] inputs, class_1291[] effects, int duration) {
        return new StewTrade(inputs, effects, duration);
    }

    public static PotionTrade createPotionTrade(TradeItem[] inputs) {
        return new PotionTrade(inputs);
    }

    public static void setAbstractTrades(Map<Integer, class_3853.class_1652[]> tradeMap, int level, List<class_3853.class_1652> listings) {
        tradeMap.put(level, listings.toArray(new class_3853.class_1652[0]));
    }

    public static List<class_3853.class_1652> getAbstractTrades(Map<Integer, class_3853.class_1652[]> tradeMap, int level) {
        class_3853.class_1652[] listings = tradeMap.get(level);
        if (listings == null) {
            return new ArrayList<class_3853.class_1652>();
        }
        return new ArrayList<class_3853.class_1652>(Arrays.asList(listings));
    }

    public static List<class_3853.class_1652> getVillagerTrades(class_3852 profession) {
        return CACHED_PROFESSION_TRADES.computeIfAbsent(profession, p -> {
            Int2ObjectMap levelListings = (Int2ObjectMap)class_3853.field_17067.get(p);
            if (levelListings == null) {
                return List.of();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ObjectIterator objectIterator = levelListings.values().iterator();
            while (objectIterator.hasNext()) {
                class_3853.class_1652[] listings;
                for (class_3853.class_1652 listing : listings = (class_3853.class_1652[])objectIterator.next()) {
                    builder.add((Object)listing);
                }
            }
            return builder.build();
        });
    }

    public static List<class_3853.class_1652> getVillagerTrades(class_3852 profession, int level) {
        Int2ObjectMap levelListings = (Int2ObjectMap)class_3853.field_17067.get(profession);
        if (levelListings == null) {
            return List.of();
        }
        class_3853.class_1652[] listings = (class_3853.class_1652[])levelListings.get(level);
        if (listings == null) {
            return List.of();
        }
        return Arrays.asList(listings);
    }

    public static class_3853.class_1652 getRandomVillagerTrade(class_3852 profession) {
        List<class_3853.class_1652> trades = VillagerUtils.getVillagerTrades(profession);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Profession " + profession + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }

    public static class_3853.class_1652 getRandomVillagerTrade(class_3852 profession, int level) {
        List<class_3853.class_1652> trades = VillagerUtils.getVillagerTrades(profession, level);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Profession " + profession + " on level " + level + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }

    public static List<class_3853.class_1652> getWandererTrades(int level) {
        class_3853.class_1652[] listings = (class_3853.class_1652[])class_3853.field_17724.get(level);
        if (listings == null) {
            return List.of();
        }
        return Arrays.asList(listings);
    }

    public static class_3853.class_1652 getRandomWandererTrade(int level) {
        List<class_3853.class_1652> trades = VillagerUtils.getWandererTrades(level);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Wanderer on level " + level + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }
}

