/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeTypes;
import com.almostreliable.morejs.util.TriConsumer;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3852;

public class TradeFilter {
    private final class_1856 firstMatcher;
    private final class_1856 secondMatcher;
    private final class_1856 outputMatcher;
    private IntRange merchantLevelMatch = IntRange.all();
    private IntRange firstCountMatcher = IntRange.all();
    private IntRange secondCountMatcher = IntRange.all();
    private IntRange outputCountMatcher = IntRange.all();
    private TriConsumer<class_1799, class_1799, class_1799> onMatch = ($1, $2, $3) -> {};
    @Nullable
    private Set<TradeTypes> tradeTypes;
    @Nullable
    private Set<class_3852> professions;

    public TradeFilter(class_1856 firstMatcher, class_1856 secondMatcher, class_1856 outputMatcher) {
        this.firstMatcher = firstMatcher;
        this.secondMatcher = secondMatcher;
        this.outputMatcher = outputMatcher;
    }

    public void onMatch(TriConsumer<class_1799, class_1799, class_1799> onMatch) {
        this.onMatch = onMatch;
    }

    public void setMerchantLevelMatcher(IntRange merchantLevelMatch) {
        this.merchantLevelMatch = merchantLevelMatch;
    }

    public void setFirstCountMatcher(IntRange firstCountMatcher) {
        this.firstCountMatcher = firstCountMatcher;
    }

    public void setSecondCountMatcher(IntRange secondCountMatcher) {
        this.secondCountMatcher = secondCountMatcher;
    }

    public void setOutputCountMatcher(IntRange outputCountMatcher) {
        this.outputCountMatcher = outputCountMatcher;
    }

    public void setTradeTypes(Set<TradeTypes> tradeTypes) {
        this.tradeTypes = tradeTypes;
    }

    public void setProfessions(@Nullable Set<class_3852> professions) {
        this.professions = professions;
    }

    public boolean matchMerchantLevel(int level) {
        return this.merchantLevelMatch.test(level);
    }

    public boolean matchProfession(class_3852 profession) {
        return this.professions == null || this.professions.contains(profession);
    }

    public boolean matchType(TradeTypes type) {
        return this.tradeTypes == null || this.tradeTypes.contains((Object)type);
    }

    public boolean match(class_1799 first, class_1799 second, class_1799 output, TradeTypes type) {
        boolean matched;
        boolean firstMatch = this.firstMatcher.method_8093(first) && this.firstCountMatcher.test(first.method_7947());
        boolean secondMatch = this.secondMatcher.method_8093(second) && this.secondCountMatcher.test(second.method_7947());
        boolean outputMatch = this.outputMatcher.method_8093(output) && this.outputCountMatcher.test(output.method_7947());
        boolean bl = matched = this.matchType(type) && firstMatch && secondMatch && outputMatch;
        if (matched) {
            this.onMatch.accept(first, second, output);
        }
        return matched;
    }

    public boolean match(class_1799 first, class_1799 output, TradeTypes type) {
        return this.match(first, class_1799.field_8037, output, type);
    }

    public static interface Filterable {
        default public boolean matchesTradeFilter(TradeFilter filter) {
            return false;
        }
    }
}

