/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.mixin.potion.PotionBrewingAccessor;
import com.almostreliable.morejs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.HashSet;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public abstract class PotionBrewingRegisterEvent
extends EventJS {
    protected void validate(class_1856 topInput, class_1856 bottomInput, class_1799 output) {
        Preconditions.checkArgument((topInput.method_8105().length > 0 ? 1 : 0) != 0, (Object)"Top input must have at least one item");
        Preconditions.checkArgument((bottomInput.method_8105().length > 0 ? 1 : 0) != 0, (Object)"Bottom input must have at least one item");
        Preconditions.checkArgument((!output.method_7960() ? 1 : 0) != 0, (Object)"Output must not be empty");
    }

    protected void validateSimple(class_1842 from, class_1856 ingredient, class_1842 to) {
        Preconditions.checkNotNull((Object)from, (Object)"Input potion must not be null");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkNotNull((Object)to, (Object)"Output potion must not be null");
        Preconditions.checkArgument((ingredient.method_8105().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
    }

    public abstract void addCustomBrewing(class_1856 var1, class_1856 var2, class_1799 var3);

    public abstract void addPotionBrewing(class_1856 var1, class_1842 var2, class_1842 var3);

    public void addPotionBrewing(class_1856 ingredient, class_1842 output) {
        this.addPotionBrewing(ingredient, class_1847.field_8991, output);
    }

    public void removeByPotion(@Nullable class_1842 input, @Nullable class_1856 ingredient, @Nullable class_1842 output) {
        PotionBrewingAccessor.getMixes().removeIf(mix -> {
            boolean matches;
            boolean matchesInput = input == null || this.getInputPotionFromMix((class_1845.class_1846<class_1842>)mix) == input;
            boolean matchesIngredient = ingredient == null || Utils.matchesIngredient(ingredient, mix.field_8960);
            boolean matchesOutput = output == null || this.getOutputPotionFromMix((class_1845.class_1846<class_1842>)mix) == output;
            boolean bl = matches = matchesInput && matchesIngredient && matchesOutput;
            if (matches) {
                ConsoleJS.STARTUP.info((Object)("Removed potion brewing recipe: " + class_7923.field_41179.method_10221((Object)this.getInputPotionFromMix((class_1845.class_1846<class_1842>)mix)) + " + " + StringUtils.abbreviate((String)mix.field_8960.method_8089().toString(), (int)64) + " -> " + class_7923.field_41179.method_10221((Object)this.getOutputPotionFromMix((class_1845.class_1846<class_1842>)mix))));
            }
            return matches;
        });
    }

    protected abstract class_1842 getInputPotionFromMix(class_1845.class_1846<class_1842> var1);

    protected abstract class_1842 getOutputPotionFromMix(class_1845.class_1846<class_1842> var1);

    protected abstract class_1792 getOutputItemFromMix(class_1845.class_1846<class_1792> var1);

    public void removeContainer(class_1856 ingredient) {
        HashSet<class_1792> removed = new HashSet<class_1792>();
        ListIterator<class_1856> containerIt = PotionBrewingAccessor.getAllowedContainers().listIterator();
        while (containerIt.hasNext()) {
            class_1856 ac = containerIt.next();
            if (!Utils.matchesIngredient(ac, ingredient)) continue;
            containerIt.remove();
            for (class_1799 item : ac.method_8105()) {
                removed.add(item.method_7909());
            }
        }
        ListIterator<class_1845.class_1846<class_1792>> mixIt = PotionBrewingAccessor.getContainerMixes().listIterator();
        while (mixIt.hasNext()) {
            class_1845.class_1846<class_1792> mix = mixIt.next();
            class_1792 output = this.getOutputItemFromMix(mix);
            if (!ingredient.method_8093(output.method_7854())) continue;
            mixIt.remove();
            removed.add(output);
        }
        for (class_1792 item : removed) {
            ConsoleJS.STARTUP.info((Object)("Removed potion container: " + class_7923.field_41178.method_10221((Object)item)));
        }
    }

    public void validateContainer(class_1792 from, class_1856 ingredient, class_1792 output) {
        Preconditions.checkArgument((from != null && from != class_1802.field_8162 ? 1 : 0) != 0, (Object)"Input must not be null or air");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkArgument((ingredient.method_8105().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
        Preconditions.checkArgument((output != null && output != class_1802.field_8162 ? 1 : 0) != 0, (Object)"Output must not be null or air");
    }

    public abstract void addContainerRecipe(class_1792 var1, class_1856 var2, class_1792 var3);
}

