/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentMenuProcess;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableEventJS;
import com.almostreliable.morejs.features.villager.IntRange;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EnchantmentTableServerEventJS
extends EnchantmentTableEventJS {
    protected final EnchantmentMenuProcess state;
    private final class_2338 pos;
    private boolean itemChanged;

    public EnchantmentTableServerEventJS(class_1799 item, class_1799 secondItem, class_1937 level, class_2338 pos, class_1657 player, EnchantmentMenuProcess state) {
        super(item, secondItem, level, player, state.getMenu());
        this.pos = pos;
        this.state = state;
    }

    public class_2338 getPosition() {
        return this.pos;
    }

    public Data get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getSize());
        return new Data(index);
    }

    public int getSize() {
        return this.state.getMenu().field_7808.length;
    }

    public void setItem(class_1799 item) {
        this.itemChanged = true;
        this.item = item;
    }

    public boolean itemWasChanged() {
        return this.itemChanged;
    }

    public class Data {
        protected final int index;

        protected Data(int index) {
            this.index = index;
        }

        public int getRequiredLevel() {
            return EnchantmentTableServerEventJS.this.menu.field_7808[this.index];
        }

        public int getEnchantmentCount() {
            return this.getEnchantments().size();
        }

        public void forEachEnchantments(BiConsumer<class_1887, Integer> consumer) {
            this.getEnchantments().forEach(i -> consumer.accept(i.field_9093, i.field_9094));
        }

        public void clearEnchantments() {
            this.getEnchantments().clear();
        }

        public List<class_2960> getEnchantmentIds() {
            return this.getEnchantments().stream().map(e -> class_7923.field_41176.method_10221((Object)e.field_9093)).filter(Objects::nonNull).toList();
        }

        public boolean hasEnchantment(class_2960 id) {
            return this.hasEnchantment(id, IntRange.all());
        }

        public boolean hasEnchantment(class_2960 id, IntRange range) {
            class_1887 enchantment = class_7923.field_41176.method_17966(id).orElse(null);
            if (enchantment == null) {
                return false;
            }
            for (class_1889 enchantmentInstance : this.getEnchantments()) {
                if (enchantmentInstance.field_9093 != enchantment || !range.test(enchantmentInstance.field_9094)) continue;
                return true;
            }
            return false;
        }

        protected List<class_1889> getEnchantments() {
            return EnchantmentTableServerEventJS.this.state.getEnchantments(this.index);
        }
    }
}

