/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

@ApiStatus.Internal
public class MoonlightClient {
    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static MergedDynamicTexturePack mergedDynamicPack;

    public static void initClient() {
        ClientHelper.addClientReloadListener(SoftFluidColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
        ClientConfigs.init();
        Gen gen = new Gen();
        gen.register();
    }

    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (!ClientConfigs.MERGE_PACKS.get().booleanValue()) {
            return pack;
        }
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack(){};
        }
        Set<String> nameSpaces = pack.method_14406(pack.getPackType());
        for (String n : nameSpaces) {
            mergedDynamicPack.addNamespaces(n);
        }
        ++MoonlightClient.mergedDynamicPack.mods;
        return mergedDynamicPack;
    }

    public static void afterTextureReload() {
        DynamicResourcePack.clearAfterReload(class_3264.field_14188);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }

    private static class Gen
    extends DynClientResourcesGenerator {
        private Vector3f oldL0 = null;
        private Vector3f oldL1 = null;
        private Vector3f oldL0n = null;
        private Vector3f oldL1n = null;

        public Gen() {
            super(new DynamicTexturePack(Moonlight.res("generated_pack")));
            ((DynamicTexturePack)this.dynamicPack).addNamespaces("minecraft");
        }

        @Override
        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        @Override
        public boolean dependsOnLoadedPacks() {
            return false;
        }

        @Override
        public void regenerateDynamicAssets(class_3300 manager) {
            if (ClientConfigs.FIX_SHADE.get().booleanValue()) {
                if (this.oldL0 == null) {
                    this.oldL0 = class_308.field_24426;
                    this.oldL1 = class_308.field_24427;
                    this.oldL0n = class_308.field_24428;
                    this.oldL1n = class_308.field_24429;
                }
                float x = 0.2f;
                float y = 0.7777778f;
                float z = -0.6f;
                class_308.field_24426 = new Vector3f(x, y, z).normalize();
                class_308.field_24427 = new Vector3f(-x, y, -z).normalize();
                class_308.field_24428 = class_308.field_24426;
                class_308.field_24429 = class_308.field_24427;
                ((DynamicTexturePack)this.dynamicPack).addBytes(new class_2960("shaders/include/light.glsl"), "#version 150\n\n#define MINECRAFT_LIGHT_POWER   (0.5)\n#define MINECRAFT_AMBIENT_LIGHT (0.5)\n\nvec4 minecraft_mix_light(vec3 lightDir0, vec3 lightDir1, vec3 normal, vec4 color) {\n    lightDir0 = normalize(lightDir0);\n    lightDir1 = normalize(lightDir1);\n    float light0 = max(0.0, dot(lightDir0, normal));\n    float light1 = max(0.0, dot(lightDir1, normal));\n    float lightAccum = min(1.0, (light0 + light1) * MINECRAFT_LIGHT_POWER + MINECRAFT_AMBIENT_LIGHT);\n    return vec4(color.rgb * lightAccum, color.a);\n}\n\nvec4 minecraft_sample_lightmap(sampler2D lightMap, ivec2 uv) {\n    return texture(lightMap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0)));\n}".getBytes(), ResType.GENERIC);
            } else if (this.oldL0 != null) {
                class_308.field_24426 = this.oldL0;
                class_308.field_24427 = this.oldL1;
                class_308.field_24428 = this.oldL0n;
                class_308.field_24429 = this.oldL1n;
                this.oldL0 = null;
                this.oldL1 = null;
                this.oldL0n = null;
                this.oldL1n = null;
            }
        }
    }

    private static class MergedDynamicTexturePack
    extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public class_2561 makeDescription() {
            return class_2561.method_43470((String)("Dynamic resources for " + this.mods + (this.mods == 1 ? " mod" : " mods")));
        }
    }
}

