/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidTankImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class SoftFluidTank {
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    protected final int capacity;
    protected SoftFluidStack fluidStack = SoftFluidStack.empty();
    protected int stillTintCache = 0;
    protected int flowingTintCache = 0;
    protected int particleTintCache = 0;
    protected boolean needsColorRefresh = true;

    protected SoftFluidTank(int capacity) {
        this.capacity = capacity;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidTank create(int capacity) {
        return SoftFluidTankImpl.create(capacity);
    }

    public boolean interactWithPlayer(class_1657 player, class_1268 hand, @Nullable class_1937 world, @Nullable class_2338 pos) {
        class_1799 handStack = player.method_5998(hand);
        class_1799 returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.method_7960()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)handStack.method_7909()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public class_1799 interactWithItem(class_1799 stack, class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        class_1271<class_1799> fillResult = this.fillItem(stack, world, pos, simulate);
        if (fillResult.method_5467().method_23665()) {
            return (class_1799)fillResult.method_5466();
        }
        class_1271<class_1799> drainResult = this.drainItem(stack, world, pos, simulate);
        if (drainResult.method_5467().method_23665()) {
            return (class_1799)drainResult.method_5466();
        }
        return null;
    }

    public class_1271<class_1799> drainItem(class_1799 filledContainerStack, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.drainItem(filledContainerStack, world, pos, simulate, true);
    }

    public class_1271<class_1799> drainItem(class_1799 filledContainer, class_1937 level, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        Pair<SoftFluidStack, FluidContainerList.Category> extracted = SoftFluidStack.fromItem(filledContainer);
        if (extracted != null && this.canAddSoftFluid((SoftFluidStack)extracted.getFirst())) {
            SoftFluidStack fluidStack = (SoftFluidStack)extracted.getFirst();
            FluidContainerList.Category category = (FluidContainerList.Category)extracted.getSecond();
            class_1799 emptyContainer = category.getEmptyContainer().method_7854();
            if (!simulate) {
                if (this.isEmpty()) {
                    this.setFluid(fluidStack);
                } else {
                    this.addFluidOntoExisting(fluidStack);
                }
                class_3414 sound = category.getEmptySound();
                if (sound != null && pos != null) {
                    level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            return class_1271.method_29237((Object)emptyContainer, (boolean)level.field_9236);
        }
        return class_1271.method_22430((Object)class_1799.field_8037);
    }

    public class_1271<class_1799> fillItem(class_1799 emptyContainer, @Nullable class_1937 world, @Nullable class_2338 pos, boolean simulate) {
        return this.fillItem(emptyContainer, world, pos, simulate, true);
    }

    public class_1271<class_1799> fillItem(class_1799 emptyContainer, class_1937 level, @Nullable class_2338 pos, boolean simulate, boolean playSound) {
        Pair<class_1799, FluidContainerList.Category> pair = this.fluidStack.toItem(emptyContainer, simulate);
        if (pair != null) {
            FluidContainerList.Category category = (FluidContainerList.Category)pair.getSecond();
            class_3414 sound = category.getEmptySound();
            if (sound != null && pos != null) {
                level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1271.method_29237((Object)((class_1799)pair.getFirst()), (boolean)level.field_9236);
        }
        return class_1271.method_22430((Object)class_1799.field_8037);
    }

    protected void addFluidOntoExisting(SoftFluidStack stack) {
        this.fluidStack.grow(stack.getCount());
    }

    @Nullable
    public class_1271<class_1799> fillBottle(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8469.method_7854(), world, pos, false);
    }

    @Nullable
    public class_1271<class_1799> fillBucket(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8550.method_7854(), world, pos, false);
    }

    @Nullable
    public class_1271<class_1799> fillBowl(class_1937 world, class_2338 pos) {
        return this.fillItem(class_1802.field_8428.method_7854(), world, pos, false);
    }

    public boolean canAddSoftFluid(SoftFluidStack fluidStack) {
        if (this.isEmpty()) {
            return true;
        }
        if (!this.fluidStack.isFluidEqual(fluidStack)) {
            return false;
        }
        return this.getSpace() >= fluidStack.getCount();
    }

    public boolean addFluid(SoftFluidStack stack) {
        if (this.canAddSoftFluid(stack)) {
            if (this.isEmpty()) {
                this.setFluid(stack);
            } else {
                this.addFluidOntoExisting(stack);
            }
            return true;
        }
        return false;
    }

    public boolean transferFluid(SoftFluidTank destination) {
        return this.transferFluid(destination, 1);
    }

    public boolean transferFluid(SoftFluidTank destination, int amount) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.getFluidCount() >= amount && destination.addFluid(this.fluidStack.copyWithCount(amount))) {
            this.fluidStack.shrink(amount);
            return true;
        }
        return false;
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluidStack.getCount());
    }

    public int getFluidCount() {
        return this.fluidStack.getCount();
    }

    public boolean isFull() {
        return this.fluidStack.getCount() == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluidStack.isEmpty();
    }

    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.fluidStack.getCount() / (float)this.capacity;
    }

    public int getComparatorOutput() {
        float f = (float)this.fluidStack.getCount() / (float)this.capacity;
        return class_3532.method_15375((float)(f * 14.0f)) + 1;
    }

    public SoftFluidStack getFluid() {
        return this.fluidStack;
    }

    public SoftFluid getFluidValue() {
        return (SoftFluid)this.fluidStack.getHolder().comp_349();
    }

    public void setFluid(SoftFluidStack fluid) {
        this.fluidStack = fluid;
        this.refreshTintCache();
    }

    public void refreshTintCache() {
        this.stillTintCache = 0;
        this.needsColorRefresh = true;
    }

    private void fillCount() {
        this.fluidStack.setCount(this.capacity);
    }

    public void clear() {
        this.setFluid(SoftFluidStack.empty());
    }

    public void copyContent(SoftFluidTank other) {
        SoftFluidStack stack = other.getFluid();
        this.setFluid(stack.copyWithCount(Math.min(this.capacity, stack.getCount())));
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void capCapacity() {
        this.fluidStack.setCount(class_3532.method_15340((int)this.fluidStack.getCount(), (int)0, (int)this.capacity));
    }

    private void cacheColors(@Nullable class_1920 world, @Nullable class_2338 pos) {
        this.stillTintCache = this.fluidStack.getStillColor(world, pos);
        this.flowingTintCache = this.fluidStack.getFlowingColor(world, pos);
        this.particleTintCache = this.fluidStack.getParticleColor(world, pos);
        this.needsColorRefresh = false;
    }

    @Deprecated(forRemoval=true)
    public int getTintColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        return this.getCachedStillColor(world, pos);
    }

    @Deprecated(forRemoval=true)
    public int getFlowingTint(@Nullable class_1920 world, @Nullable class_2338 pos) {
        return this.getCachedFlowingColor(world, pos);
    }

    @Deprecated(forRemoval=true)
    public int getParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        return this.getCachedParticleColor(world, pos);
    }

    public int getCachedStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.stillTintCache;
    }

    public int getCachedFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.flowingTintCache;
    }

    public int getCachedParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        if (this.needsColorRefresh) {
            this.cacheColors(world, pos);
        }
        return this.particleTintCache;
    }

    public boolean containsFood() {
        return !this.fluidStack.getFoodProvider().isEmpty();
    }

    public void load(class_2487 compound) {
        if (compound.method_10545("FluidHolder")) {
            class_2487 cmp = compound.method_10562("FluidHolder");
            this.fluidStack = SoftFluidStack.load(cmp);
            if (this.isEmpty()) {
                this.fluidStack = SoftFluidStack.empty();
            }
        }
    }

    public class_2487 save(class_2487 compound) {
        class_2487 cmp = new class_2487();
        if (this.isEmpty()) {
            this.fluidStack = SoftFluidStack.empty();
        }
        this.fluidStack.save(cmp);
        compound.method_10566("FluidHolder", (class_2520)cmp);
        return compound;
    }

    public boolean tryDrinkUpFluid(class_1657 player, class_1937 world) {
        if (!this.isEmpty() && this.containsFood()) {
            if (this.fluidStack.getFoodProvider().consume(player, world, this.fluidStack::applyNBTtoItemStack)) {
                this.fluidStack.shrink(1);
                return true;
            }
        }
        return false;
    }

    public static int getLiquidCountFromItem(class_1792 i) {
        if (i == class_1802.field_8469) {
            return 1;
        }
        if (i == class_1802.field_8428) {
            return 2;
        }
        if (i == class_1802.field_8550) {
            return 4;
        }
        return 0;
    }
}

