/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.fabric;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadEmitter inner;
    private final class_1058 sprite;
    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;
    private Consumer<class_777> quadConsumer;
    private int vertexIndex = 0;
    private boolean autoDirection = false;

    public static BakedQuadBuilder create(class_1058 sprite, @Nullable Matrix4f transformation) {
        return new BakedQuadBuilderImpl(sprite, transformation);
    }

    private BakedQuadBuilderImpl(class_1058 sprite, @Nullable Matrix4f transform) {
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        this.inner = meshBuilder.getEmitter();
        this.globalTransform = transform;
        this.sprite = sprite;
        this.inner.spriteBake(sprite, 4);
        this.normalTransf = transform == null ? null : new Matrix3f((Matrix4fc)transform).invert().transpose();
    }

    @Override
    public BakedQuadBuilder setAutoBuild(Consumer<class_777> quadConsumer) {
        this.quadConsumer = quadConsumer;
        return this;
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        this.inner.colorIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAutoDirection() {
        this.autoDirection = true;
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setShade(boolean shade) {
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAmbientOcclusion(boolean ambientOcclusion) {
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setDirection(class_2350 direction) {
        if (this.globalTransform != null) {
            direction = class_2350.method_23225((Matrix4f)this.globalTransform, (class_2350)direction);
        }
        this.inner.nominalFace(direction);
        return this;
    }

    public BakedQuadBuilderImpl vertex(double x, double y, double z) {
        if (this.globalTransform != null) {
            Vector4f v = this.globalTransform.transform(new Vector4f((float)x, (float)y, (float)z, 1.0f));
            this.inner.pos(this.vertexIndex, v.x(), v.y(), v.z());
            return this;
        }
        this.inner.pos(this.vertexIndex, (float)x, (float)y, (float)z);
        return this;
    }

    public BakedQuadBuilderImpl normal(float x, float y, float z) {
        if (this.globalTransform != null) {
            Vector3f normal = this.normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            this.inner.normal(this.vertexIndex, normal.x(), normal.y(), normal.z());
        } else {
            this.inner.normal(this.vertexIndex, x, y, z);
        }
        if (this.autoDirection) {
            this.setDirection(class_2350.method_10147((float)x, (float)y, (float)z));
        }
        return this;
    }

    public BakedQuadBuilderImpl color(int rgba) {
        this.inner.color(this.vertexIndex, rgba);
        return this;
    }

    public BakedQuadBuilderImpl color(int r, int g, int b, int a) {
        return this.color((a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF);
    }

    public BakedQuadBuilderImpl uv(float u, float v) {
        this.inner.uv(this.vertexIndex, this.sprite.method_4580((double)(u * 16.0f)), this.sprite.method_4570((double)(v * 16.0f)));
        return this;
    }

    public BakedQuadBuilderImpl overlayCoords(int u, int v) {
        return this;
    }

    public BakedQuadBuilderImpl uv2(int u, int v) {
        this.inner.lightmap(this.vertexIndex, u & 0xFFFF | (v & 0xFFFF) << 16);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl lightEmission(int lightLevel) {
        this.inner.material(RendererAccess.INSTANCE.getRenderer().materialFinder().emissive(true).find());
        return this;
    }

    public void method_1344() {
        ++this.vertexIndex;
        if (this.vertexIndex == 4) {
            this.vertexIndex = 0;
            if (this.quadConsumer != null) {
                this.quadConsumer.accept(this.build());
            }
        }
    }

    public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {
    }

    public void method_35666() {
    }

    @Override
    public BakedQuadBuilder fromVanilla(class_777 quad) {
        this.inner.fromVanilla(quad, RendererAccess.INSTANCE.getRenderer().materialFinder().find(), null);
        return null;
    }

    @Override
    public class_777 build() {
        Preconditions.checkNotNull((Object)this.sprite, (Object)"sprite cannot be null");
        return this.inner.toBakedQuad(this.sprite);
    }
}

