/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.desht.modularrouters.ModularRouters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

@ParametersAreNonnullByDefault
public final class Scheduler
extends AbstractListeningExecutorService {
    private static final Scheduler server;
    private static final Scheduler client;
    private final ConcurrentLinkedQueue<Task> inputQueue = new ConcurrentLinkedQueue();
    private Task[] activeTasks = new Task[5];
    private int size = 0;

    public static Scheduler server() {
        return server;
    }

    public static Scheduler client() {
        return client;
    }

    public static Scheduler forSide(Dist side) {
        return side == Dist.CLIENT ? client : server;
    }

    public void schedule(Runnable r, long tickDelay) {
        Preconditions.checkArgument((tickDelay >= 0L ? 1 : 0) != 0);
        this.execute(new WaitingTask(r, tickDelay));
    }

    public void execute(Runnable task) {
        this.execute(new WrappedRunnable(task));
    }

    public void execute(Task task) {
        this.inputQueue.offer(task);
    }

    public void tick() {
        Task task;
        Task[] activeTasks = this.activeTasks;
        int size = this.size;
        int free = -1;
        for (int idx = 0; idx < size; ++idx) {
            Task t = activeTasks[idx];
            if (!Scheduler.checkedExecute(t)) {
                activeTasks[idx] = null;
                if (free != -1) continue;
                free = idx;
                continue;
            }
            if (free == -1) continue;
            activeTasks[free++] = t;
            activeTasks[idx] = null;
        }
        if (free != -1) {
            this.size = free;
        }
        while ((task = this.inputQueue.poll()) != null) {
            if (!Scheduler.checkedExecute(task)) continue;
            if (size == activeTasks.length) {
                Task[] newArr = new Task[size << 1];
                System.arraycopy(activeTasks, 0, newArr, 0, size);
                this.activeTasks = newArr;
                activeTasks = newArr;
            }
            activeTasks[size] = task;
            ++this.size;
        }
    }

    private static boolean checkedExecute(Task task) {
        try {
            return task.execute();
        }
        catch (Throwable x) {
            ModularRouters.LOGGER.error(String.format("Exception thrown during execution of %s", task));
            return false;
        }
    }

    @Deprecated
    public boolean isShutdown() {
        return false;
    }

    @Deprecated
    public boolean isTerminated() {
        return false;
    }

    @Deprecated
    public void shutdown() {
    }

    @Nonnull
    @Deprecated
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Deprecated
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = unit.toMillis(timeout);
        long milliNanos = TimeUnit.MILLISECONDS.toNanos(millis);
        int additionalNanos = Ints.saturatedCast((long)(unit.toNanos(timeout) - milliNanos));
        Thread.sleep(millis, additionalNanos);
        return false;
    }

    private Scheduler() {
    }

    static {
        client = EffectiveSide.get() == LogicalSide.CLIENT ? new Scheduler() : null;
        server = new Scheduler();
    }

    private static class WrappedRunnable
    implements Task {
        private final Runnable task;

        public WrappedRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean execute() {
            this.task.run();
            return false;
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static final class WaitingTask
    implements Task {
        private final Runnable r;
        private long ticks;

        WaitingTask(Runnable r, long ticks) {
            this.r = r;
            this.ticks = ticks;
        }

        @Override
        public boolean execute() {
            if (--this.ticks == 0L) {
                this.r.run();
                return false;
            }
            return true;
        }

        public String toString() {
            return String.format("Scheduled task (task=%s, remainingTicks=%s)", this.r, this.ticks);
        }
    }

    public static interface Task {
        public boolean execute();
    }
}

