/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import net.minecraft.item.ItemStack;

public class RegexMatcher
implements IItemMatcher {
    private final List<Pattern> patterns;

    public RegexMatcher(List<String> regex) {
        this.patterns = Lists.newArrayListWithCapacity((int)regex.size());
        for (String r : regex) {
            try {
                Pattern pat = Pattern.compile(r, 2);
                this.patterns.add(pat);
            }
            catch (PatternSyntaxException e) {
                ModularRouters.LOGGER.warn("can't compile '" + r + "' - " + e.getMessage());
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        if (stack.func_190926_b()) {
            return false;
        }
        String name = stack.func_77973_b().getRegistryName().func_110623_a();
        for (Pattern pat : this.patterns) {
            if (!pat.matcher(name).find()) continue;
            return true;
        }
        return false;
    }
}

