/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CompiledBreakerModule
extends CompiledModule {
    public static final String NBT_MATCH_TYPE = "MatchType";
    private final ItemStack pickaxe;
    private final MatchType matchType;

    public CompiledBreakerModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        this.pickaxe = ((IPickaxeUser)stack.func_77973_b()).getPickaxe(stack);
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        this.matchType = MatchType.values()[compound.func_74762_e(NBT_MATCH_TYPE)];
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() && EnchantmentHelper.func_82781_a((ItemStack)this.pickaxe).isEmpty()) {
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)stack), (ItemStack)this.pickaxe);
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        if (this.isRegulationOK(router, true)) {
            World world = router.func_145831_w();
            if (!(world instanceof ServerWorld)) {
                return false;
            }
            BlockPos pos = this.getTarget().gPos.func_218180_b();
            BlockState oldState = world.func_180495_p(pos);
            BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(router, world, pos, this.getFilter(), this.pickaxe, this.matchType == MatchType.BLOCK);
            if (breakResult.isBlockBroken()) {
                breakResult.processDrops(world, pos, router.getBuffer());
                if (MRConfig.Common.Module.breakerParticles && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0) {
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)oldState));
                }
                return true;
            }
        }
        return false;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public static enum MatchType implements IHasTranslationKey
    {
        ITEM,
        BLOCK;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.breakMatchType." + this;
        }
    }
}

