/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.upgrade.GuiSyncUpgrade;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SyncUpgrade
extends ItemUpgrade {
    private static final String NBT_TUNING = "Tuning";

    @Override
    public void addExtraInformation(ItemStack itemstack, List<ITextComponent> list) {
        list.add((ITextComponent)ClientUtil.xlate("modularrouters.itemText.sync.tuning", SyncUpgrade.getTunedValue(itemstack)));
    }

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        router.setTunedSyncValue(SyncUpgrade.getTunedValue(stack));
    }

    public static int getTunedValue(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof SyncUpgrade) || !stack.func_77942_o()) {
            return 0;
        }
        CompoundNBT tag = stack.func_179543_a("modularrouters");
        return tag == null ? 0 : tag.func_74762_e(NBT_TUNING);
    }

    public static void setTunedValue(ItemStack stack, int newValue) {
        if (stack.func_77973_b() instanceof SyncUpgrade) {
            stack.func_190925_c("modularrouters").func_74768_a(NBT_TUNING, newValue);
        }
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(255, 255, 192);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && !player.func_226271_bk_()) {
            GuiSyncUpgrade.openSyncGui(stack, hand);
        } else if (player.func_226271_bk_()) {
            if (!world.field_72995_K) {
                SyncUpgrade.setTunedValue(stack, world.field_73012_v.nextInt(MRConfig.Common.Router.baseTickRate));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("modularrouters.itemText.sync.tuning", new Object[]{SyncUpgrade.getTunedValue(stack)}), true);
            } else {
                player.func_184185_a((SoundEvent)ModSounds.SUCCESS.get(), 1.0f, 1.5f);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }
}

