/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class XPCollection {
    private static final Set<XPCollectionType> AVAILABLE = EnumSet.noneOf(XPCollectionType.class);
    private static final Map<XPCollectionType, ItemStack> ICONS = new EnumMap<XPCollectionType, ItemStack>(XPCollectionType.class);

    public static void detectXPTypes() {
        ICONS.clear();
        for (XPCollectionType type : XPCollectionType.values()) {
            if (XPCollection.getIconForResource(type).func_190926_b()) continue;
            AVAILABLE.add(type);
        }
    }

    private static ItemStack getIconForResource(XPCollectionType type) {
        if (!ICONS.containsKey((Object)type)) {
            if (type.isSolid()) {
                ICONS.put(type, new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(type.getRegistryName())));
            } else {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(type.getRegistryName());
                ICONS.put(type, fluid == null || fluid == Fluids.field_204541_a ? ItemStack.field_190927_a : FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)));
            }
        }
        return ICONS.getOrDefault((Object)type, ItemStack.field_190927_a);
    }

    public static XPCollectionType getXPType(int type) {
        XPCollectionType xpType = XPCollectionType.values()[type];
        if (!xpType.isAvailable()) {
            xpType = XPCollectionType.BOTTLE_O_ENCHANTING;
        }
        return xpType;
    }

    public static enum XPCollectionType {
        SOLIDIFIED_EXPERIENCE(true, 8, "actuallyadditions:item_solidified_experience"),
        BOTTLE_O_ENCHANTING(true, 7, "minecraft:experience_bottle"),
        MEMORY_ESSENCE(false, 20, "pneumaticcraft:memory_essence"),
        CYCLIC_XP_JUICE(false, 20, "cyclic:xpjuice"),
        IF_ESSENCE(false, 20, "industrialforegoing:essence");

        private final boolean solid;
        private final int xpRatio;
        private final ResourceLocation registryName;

        private XPCollectionType(boolean solid, int xpRatio, String registryName) {
            this.solid = solid;
            this.xpRatio = xpRatio;
            this.registryName = new ResourceLocation(registryName);
        }

        public int getXpRatio() {
            return this.xpRatio;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public Fluid getFluid() {
            return (Fluid)ForgeRegistries.FLUIDS.getValue(this.registryName);
        }

        public String getModId() {
            return this.registryName.func_110624_b();
        }

        public boolean isAvailable() {
            return AVAILABLE.contains((Object)this);
        }

        public ItemStack getIcon() {
            return XPCollection.getIconForResource(this);
        }

        public ITextComponent getDisplayName() {
            return XPCollection.getIconForResource(this).func_200301_q();
        }
    }
}

