/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import java.util.regex.Pattern;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Range;

public class IntegerTextField
extends TextFieldWidgetMR {
    private Range<Integer> range;
    private int incr = 1;
    private int coarseIncr = 10;
    private int fineIncr = 1;
    private static final Pattern INT_MATCHER = Pattern.compile("^-?[0-9]+$");

    public IntegerTextField(TextFieldManager parent, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, Range<Integer> range) {
        super(parent, fontrendererObj, x, y, par5Width, par6Height);
        this.setRange(range);
        this.func_200675_a(this::validate);
    }

    private boolean validate(String input) {
        if (input == null || input.isEmpty()) {
            return true;
        }
        if (!INT_MATCHER.matcher(input).matches()) {
            return false;
        }
        int n = Integer.parseInt(input);
        return this.range.contains((Object)n);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 265: {
                return this.adjustField(this.getAdjustment());
            }
            case 264: {
                return this.adjustField(-this.getAdjustment());
            }
            case 266: {
                return this.adjustField((Integer)this.range.getMaximum());
            }
            case 267: {
                return this.adjustField(-((Integer)this.range.getMaximum()).intValue());
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void setRange(Range<Integer> range) {
        this.range = range;
        if (!range.contains((Object)this.getIntValue())) {
            this.setValue(MathHelper.func_76125_a((int)this.getIntValue(), (int)((Integer)range.getMinimum()), (int)((Integer)range.getMaximum())));
        }
        this.func_146203_f(Math.max(Integer.toString((Integer)range.getMinimum()).length(), Integer.toString((Integer)range.getMaximum()).length()));
    }

    @Override
    public void onMouseWheel(int direction) {
        this.adjustField(direction > 0 ? this.getAdjustment() : -this.getAdjustment());
    }

    public void setValue(int val) {
        if (this.range.contains((Object)val)) {
            this.func_146180_a(Integer.toString(val));
        }
    }

    public int getIntValue() {
        int val;
        try {
            val = Integer.parseInt(this.func_146179_b());
        }
        catch (NumberFormatException e) {
            val = (Integer)this.range.getMinimum();
        }
        return val;
    }

    public void setIncr(int incr, int coarseAdjustMult) {
        this.setIncr(incr, coarseAdjustMult, 1);
    }

    public void setIncr(int incr, int coarseAdjustMult, int fineAdjustDiv) {
        this.incr = incr;
        this.coarseIncr = incr * coarseAdjustMult;
        this.fineIncr = incr / fineAdjustDiv;
    }

    private int getAdjustment() {
        if (Screen.func_231173_s_()) {
            return this.coarseIncr;
        }
        if (Screen.func_231172_r_()) {
            return this.fineIncr;
        }
        return this.incr;
    }

    private boolean adjustField(int adj) {
        int newVal = MathHelper.func_76125_a((int)(this.getIntValue() + adj), (int)((Integer)this.range.getMinimum()), (int)((Integer)this.range.getMaximum()));
        if (newVal != this.getIntValue()) {
            this.func_146180_a("");
            this.func_146191_b(Integer.toString(newVal));
        }
        return true;
    }
}

