/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class GuiModulePlayer
extends GuiModule {
    private static final ItemStack MAIN_INV_STACK = new ItemStack((IItemProvider)Blocks.field_150486_ae);
    private static final ItemStack MAIN_NO_HOTBAR_INV_STACK = new ItemStack((IItemProvider)Blocks.field_222422_lK);
    private static final ItemStack ARMOUR_STACK = new ItemStack((IItemProvider)Items.field_151163_ad);
    private static final ItemStack OFFHAND_STACK = new ItemStack((IItemProvider)Items.field_185159_cQ);
    private static final ItemStack ENDER_STACK = new ItemStack((IItemProvider)Blocks.field_150477_bB);
    private static final ItemStack ROUTER_STACK = new ItemStack((IItemProvider)ModBlocks.ITEM_ROUTER.get());
    private static final ItemStack[] STACKS = new ItemStack[]{MAIN_INV_STACK, MAIN_NO_HOTBAR_INV_STACK, ARMOUR_STACK, OFFHAND_STACK, ENDER_STACK};
    private SectionButton secButton;
    private OperationButton opButton;

    public GuiModulePlayer(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        CompiledPlayerModule cpm = new CompiledPlayerModule(null, this.moduleItemStack);
        this.secButton = new SectionButton(this.field_147003_i + 169, this.field_147009_r + 32, 16, 16, true, STACKS, cpm.getSection());
        this.func_230480_a_((Widget)this.secButton);
        this.opButton = new OperationButton(this.field_147003_i + 148, this.field_147009_r + 32, cpm.getOperation());
        this.func_230480_a_((Widget)this.opButton);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 127, this.field_147009_r + 29, this.field_147003_i + 187, this.field_147009_r + 50, "modularrouters.guiText.popup.player.control");
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.func_238474_b_(matrixStack, this.field_147003_i + 167, this.field_147009_r + 31, GuiModulePlayer.BUTTON_XY.x, GuiModulePlayer.BUTTON_XY.y, 18, 18);
        GuiUtil.renderItemStack(matrixStack, this.field_230706_i_, ROUTER_STACK, this.field_147003_i + 128, this.field_147009_r + 32, "");
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74768_a("Operation", ((CompiledPlayerModule.Operation)this.opButton.getState()).ordinal());
        compound.func_74768_a("Section", ((CompiledPlayerModule.Section)this.secButton.getState()).ordinal());
        return compound;
    }

    private class OperationButton
    extends TexturedCyclerButton<CompiledPlayerModule.Operation> {
        private final List<List<ITextComponent>> tooltips;

        OperationButton(int x, int y, CompiledPlayerModule.Operation initialVal) {
            super(x, y, 16, 16, initialVal, GuiModulePlayer.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledPlayerModule.Operation op : CompiledPlayerModule.Operation.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(op.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledPlayerModule.Operation)this.getState()).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(((CompiledPlayerModule.Operation)this.getState()).ordinal());
        }
    }

    private class SectionButton
    extends ItemStackCyclerButton<CompiledPlayerModule.Section> {
        private final List<List<ITextComponent>> tips;

        SectionButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledPlayerModule.Section initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, GuiModulePlayer.this);
            this.tips = Lists.newArrayList();
            for (CompiledPlayerModule.Section sect : CompiledPlayerModule.Section.values()) {
                this.tips.add(Collections.singletonList(ClientUtil.xlate(sect.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tips.get(((CompiledPlayerModule.Section)this.getState()).ordinal());
        }
    }
}

