/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.commons.lang3.Range;

public class GuiInspectionFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/inspectionfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 191;
    private int xPos;
    private int yPos;
    private InspectionMatcher.ComparisonList comparisonList;
    private IntegerTextField valueTextField;
    private InspectionMatcher.InspectionSubject currentSubject = InspectionMatcher.InspectionSubject.NONE;
    private InspectionMatcher.InspectionOp currentOp = InspectionMatcher.InspectionOp.NONE;
    private final List<Buttons.DeleteButton> deleteButtons = new ArrayList<Buttons.DeleteButton>();
    private Button matchButton;

    public GuiInspectionFilter(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.comparisonList = InspectionFilter.getComparisonList(filterStack);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.xPos = (this.field_230708_k_ - 176) / 2;
        this.yPos = (this.field_230709_l_ - 191) / 2;
        if (this.locator.filterSlot >= 0) {
            this.func_230480_a_((Widget)new BackButton(this.xPos - 12, this.yPos, button -> this.closeGUI()));
        }
        this.func_230480_a_((Widget)new Button(this.xPos + 8, this.yPos + 22, 90, 20, (ITextComponent)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]), button -> {
            this.currentSubject = this.currentSubject.cycle(Screen.func_231173_s_() ? -1 : 1);
            button.func_238482_a_((ITextComponent)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]));
        }));
        this.func_230480_a_((Widget)new Button(this.xPos + 95, this.yPos + 22, 20, 20, (ITextComponent)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]), button -> {
            this.currentOp = this.currentOp.cycle(Screen.func_231173_s_() ? -1 : 1);
            button.func_238482_a_((ITextComponent)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]));
        }));
        this.func_230480_a_((Widget)new Buttons.AddButton(this.xPos + 152, this.yPos + 23, button -> this.addEntry()));
        this.matchButton = new Button(this.xPos + 8, this.yPos + 167, 60, 20, (ITextComponent)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.isMatchAll(), new Object[0]), button -> {
            CompoundNBT ext = new CompoundNBT();
            ext.func_74757_a("MatchAll", !this.comparisonList.isMatchAll());
            PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ANY_ALL_FLAG, this.locator, ext));
        });
        this.func_230480_a_((Widget)this.matchButton);
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.func_230480_a_((Widget)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
        TextFieldManager manager = this.getOrCreateTextFieldManager().clear();
        this.valueTextField = new IntegerTextField(manager, this.field_230712_o_, this.xPos + 120, this.yPos + 28, 20, 14, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))){

            @Override
            public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257 || keyCode == 335) {
                    GuiInspectionFilter.this.addEntry();
                    return true;
                }
                return super.func_231046_a_(keyCode, scanCode, modifiers);
            }
        };
        this.valueTextField.useGuiTextBackground();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).field_230694_p_ = i < this.comparisonList.items.size();
        }
    }

    private void addEntry() {
        if (this.currentOp != InspectionMatcher.InspectionOp.NONE && this.currentSubject != InspectionMatcher.InspectionSubject.NONE) {
            int val = this.valueTextField.getIntValue();
            String s = Joiner.on((String)" ").join((Object)this.currentSubject, (Object)this.currentOp, new Object[]{val});
            this.sendAddStringMessage("Comparison", s);
            this.valueTextField.func_146180_a("");
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(textureLocation);
        this.func_238474_b_(matrixStack, this.xPos, this.yPos, 0, 0, 176, 191);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.xPos + 88.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f, (float)(this.yPos + 6), 0x404040);
        for (int i = 0; i < this.comparisonList.items.size(); ++i) {
            InspectionMatcher.Comparison comparison = this.comparisonList.items.get(i);
            this.field_230712_o_.func_238421_b_(matrixStack, comparison.asLocalizedText(), (float)(this.xPos + 28), (float)(this.yPos + 55 + i * 19), 0x404080);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void resync(ItemStack stack) {
        this.comparisonList = InspectionFilter.getComparisonList(stack);
        this.matchButton.func_238482_a_((ITextComponent)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.isMatchAll(), new Object[0]));
        this.updateDeleteButtonVisibility();
    }
}

