/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.mojang.serialization.Codec;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.OptionConvertable;
import com.terraformersmc.modmenu.util.TranslationUtil;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class EnumConfigOption<E extends Enum<E>>
implements OptionConvertable {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> class_2561 getValueText(EnumConfigOption<E> option, E value) {
        return class_2561.method_43471((String)(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT)));
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)class_2561.method_43471((String)this.translationKey), (class_2561)EnumConfigOption.getValueText(this, this.getValue()));
    }

    public class_7172<E> asOption() {
        return new class_7172(this.translationKey, class_7172.method_42399(), (text, value) -> EnumConfigOption.getValueText(this, value), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList((Enum[])this.enumClass.getEnumConstants()), Codec.STRING.xmap(string -> Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(e -> e.name().toLowerCase().equals(string)).findAny().orElse(null), newValue -> newValue.name().toLowerCase())), this.getValue(), value -> ConfigOptionStorage.setEnum(this.key, value));
    }
}

