/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items;

import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.client.particles.playerparticle.PlayerParticleData;
import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.MiningGadgets;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.capabilities.CapabilityEnergyProvider;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.sounds.LaserLoopSound;
import com.direwolf20.mininggadgets.common.sounds.OurSounds;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.direwolf20.mininggadgets.common.util.MagicHelpers;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MiningGadget
extends Item {
    private int energyCapacity;
    private Random rand = new Random();
    private LaserLoopSound laserLoopSound;

    public MiningGadget() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MiningGadgets.itemGroup).setNoRepair());
        this.energyCapacity = (Integer)Config.MININGGADGET_MAXPOWER.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityEnergyProvider(stack, (Integer)Config.MININGGADGET_MAXPOWER.get());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null).map(e -> 1.0 - (double)e.getEnergyStored() / (double)e.getMaxEnergyStored()).orElse(0.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(e -> MathHelper.func_181758_c((float)(Math.max(0.0f, (float)e.getEnergyStored() / (float)e.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f)).orElse(super.getRGBDurabilityForDisplay(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        Minecraft mc = Minecraft.func_71410_x();
        if (world == null || mc.field_71439_g == null) {
            return;
        }
        boolean sneakPressed = Screen.func_231173_s_();
        if (!sneakPressed) {
            tooltip.add((ITextComponent)new TranslationTextComponent("mininggadgets.tooltip.item.show_upgrades", new Object[]{"shift"}).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("mininggadgets.tooltip.item.break_cost", new Object[]{MiningGadget.getEnergyCost(stack)}).func_240699_a_(TextFormatting.RED));
            if (!upgrades.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("mininggadgets.tooltip.item.upgrades").func_240699_a_(TextFormatting.AQUA));
                for (Upgrade upgrade : upgrades) {
                    tooltip.add((ITextComponent)new StringTextComponent(" - " + I18n.func_135052_a((String)upgrade.getLocal(), (Object[])new Object[0])).func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
        stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energy -> {
            TranslationTextComponent energyText = !sneakPressed ? new TranslationTextComponent("mininggadgets.gadget.energy", new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}) : new TranslationTextComponent("mininggadgets.gadget.energy", new Object[]{String.format("%,d", energy.getEnergyStored()), String.format("%,d", energy.getMaxEnergyStored())});
            tooltip.add((ITextComponent)energyText.func_240699_a_(TextFormatting.GREEN));
        });
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack charged = new ItemStack((IItemProvider)this);
        charged.func_196082_o().func_74780_a("energy", (double)((Integer)Config.MININGGADGET_MAXPOWER.get()).intValue());
        items.add((Object)charged);
    }

    public static void changeRange(ItemStack tool) {
        if (MiningProperties.getRange(tool) == 1) {
            MiningProperties.setRange(tool, 3);
        } else {
            MiningProperties.setRange(tool, 1);
        }
    }

    public static boolean canMine(ItemStack tool) {
        IEnergyStorage energy = (IEnergyStorage)tool.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        int cost = MiningGadget.getEnergyCost(tool);
        if (MiningProperties.getRange(tool) == 3) {
            cost *= 9;
        }
        return energy.getEnergyStored() >= cost;
    }

    public static boolean canMineBlock(ItemStack tool, World world, PlayerEntity player, BlockPos pos, BlockState state) {
        if (!player.func_175142_cm() || !world.func_175660_a(player, pos)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))) {
            return false;
        }
        return MiningGadget.canMine(tool);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                MiningProperties.setCanMine(itemstack, true);
            }
            if (world.field_72995_K && OurKeys.shiftClickGuiBinding.getKey() == InputMappings.field_197958_a) {
                ModScreens.openGadgetSettingsScreen(itemstack);
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (world.field_72995_K) {
            float volume = MiningProperties.getVolume(itemstack);
            if (volume != 0.0f) {
                if (itemstack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                    player.func_184185_a(SoundEvents.field_187843_fX, volume * 0.5f, 1.0f);
                } else {
                    player.func_184185_a(OurSounds.LASER_START.getSound(), volume * 0.5f, 1.0f);
                }
            }
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (!MiningGadget.canMine(itemstack)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    public List<BlockPos> findSources(World world, List<BlockPos> coords) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        for (BlockPos coord : coords) {
            for (Direction side : Direction.values()) {
                BlockPos sidePos = coord.func_177972_a(side);
                FluidState state = world.func_204610_c(sidePos);
                if (!state.func_206886_c().func_207187_a((Fluid)Fluids.field_204547_b) && !state.func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a) || sources.contains(sidePos)) continue;
                sources.add(sidePos);
            }
        }
        return sources;
    }

    private void spawnFreezeParticle(PlayerEntity player, BlockPos sourcePos, World world, ItemStack stack) {
        float randomPartSize = 0.05f + 0.075f * this.rand.nextFloat();
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        double alpha = -0.5 + 0.5 * this.rand.nextDouble();
        Vector3d playerPos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vector3d look = player.func_70040_Z();
        int range = MiningProperties.getBeamRange(stack);
        BlockRayTraceResult lookAt = VectorHelper.getLookingAt(player, RayTraceContext.FluidMode.NONE, range);
        Vector3d lookingAt = lookAt.func_216347_e();
        Vector3d right = new Vector3d(-look.field_72449_c, 0.0, look.field_72450_a).func_72432_b();
        Vector3d forward = look;
        Vector3d backward = look.func_216372_d(-1.0, 1.0, -1.0);
        Vector3d down = right.func_72431_c(forward);
        right = right.func_186678_a((double)0.65f);
        forward = forward.func_186678_a((double)0.85f);
        down = down.func_186678_a(-0.35);
        backward = backward.func_186678_a(0.05);
        Vector3d laserPos = playerPos.func_178787_e(right);
        laserPos = laserPos.func_178787_e(forward);
        laserPos = laserPos.func_178787_e(down);
        lookingAt = lookingAt.func_178787_e(backward);
        PlayerParticleData data = PlayerParticleData.playerparticle("ice", (double)sourcePos.func_177958_n() + randomTX, (double)sourcePos.func_177956_o() + randomTY, (double)sourcePos.func_177952_p() + randomTZ, randomPartSize, 1.0f, 1.0f, 1.0f, 120.0f, true);
        world.func_195594_a((IParticleData)data, laserPos.field_72450_a, laserPos.field_72448_b, laserPos.field_72449_c, 0.025, (double)0.025f, 0.025);
    }

    private void spawnFireParticle(BlockPos sourcePos, ServerWorld world) {
        double partType = this.rand.nextDouble();
        if (partType < 0.75) {
            return;
        }
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        if (partType < 0.95) {
            world.func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)sourcePos.func_177958_n() + randomTX, (double)sourcePos.func_177956_o() + randomTY, (double)sourcePos.func_177952_p() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            world.func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)sourcePos.func_177958_n() + randomTX, (double)sourcePos.func_177956_o() + randomTY, (double)sourcePos.func_177952_p() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLoopSound(LivingEntity player, ItemStack stack) {
        float volume = MiningProperties.getVolume(stack);
        ClientPlayerEntity myplayer = Minecraft.func_71410_x().field_71439_g;
        if (myplayer.equals((Object)player) && volume != 0.0f) {
            if (stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                if (player.field_70170_p.func_82737_E() % 5L == 0L) {
                    if (this.rand.nextDouble() > 0.005) {
                        player.func_184185_a(SoundEvents.field_187843_fX, volume * 0.5f, 1.0f);
                    } else {
                        player.func_184185_a(SoundEvents.field_187572_ar, volume * 1.0f, 1.0f);
                    }
                }
            } else if (this.laserLoopSound == null) {
                this.laserLoopSound = new LaserLoopSound((PlayerEntity)player, volume);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.laserLoopSound);
            }
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            this.playLoopSound(player, stack);
        }
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        if (!world.field_72995_K && stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("rgb")) {
            float beam2r = (float)MiningProperties.getColor(stack, "colorRedInner") / 255.0f;
            float beam2g = (float)MiningProperties.getColor(stack, "colorGreenInner") / 255.0f;
            float beam2b = (float)MiningProperties.getColor(stack, "colorBlueInner") / 255.0f;
            float r = (float)MiningProperties.getColor(stack, "colorRed") / 255.0f;
            float g = (float)MiningProperties.getColor(stack, "colorGreen") / 255.0f;
            float b = (float)MiningProperties.getColor(stack, "colorBlue") / 255.0f;
            if (beam2r < 1.0f && beam2g == 0.0f) {
                MiningProperties.setColor(stack, (short)(beam2r * 255.0f + Math.min(255.0f - beam2r * 255.0f, 5.0f)), "colorRedInner");
            } else if (beam2b > 0.0f && beam2r == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2b * 255.0f - Math.min(Math.abs(0.0f - beam2b * 255.0f), 5.0f)), "colorBlueInner");
            } else if (beam2g < 1.0f && beam2r == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2g * 255.0f + Math.min(255.0f - beam2g * 255.0f, 5.0f)), "colorGreenInner");
            } else if (beam2r > 0.0f && beam2g == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2r * 255.0f - Math.min(Math.abs(0.0f - beam2r * 255.0f), 5.0f)), "colorRedInner");
            } else if (beam2b < 1.0f && beam2g == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2b * 255.0f + Math.min(255.0f - beam2b * 255.0f, 5.0f)), "colorBlueInner");
            } else if (beam2g > 0.0f && beam2b == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2g * 255.0f - Math.min(Math.abs(0.0f - beam2g * 255.0f), 5.0f)), "colorGreenInner");
            }
            if (r < 1.0f && g == 0.0f) {
                MiningProperties.setColor(stack, (short)(r * 255.0f + Math.min(255.0f - r * 255.0f, 5.0f)), "colorRed");
            } else if (b > 0.0f && r == 1.0f) {
                MiningProperties.setColor(stack, (short)(b * 255.0f - Math.min(Math.abs(0.0f - b * 255.0f), 5.0f)), "colorBlue");
            } else if (g < 1.0f && r == 1.0f) {
                MiningProperties.setColor(stack, (short)(g * 255.0f + Math.min(255.0f - g * 255.0f, 5.0f)), "colorGreen");
            } else if (r > 0.0f && g == 1.0f) {
                MiningProperties.setColor(stack, (short)(r * 255.0f - Math.min(Math.abs(0.0f - r * 255.0f), 5.0f)), "colorRed");
            } else if (b < 1.0f && g == 1.0f) {
                MiningProperties.setColor(stack, (short)(b * 255.0f + Math.min(255.0f - b * 255.0f, 5.0f)), "colorBlue");
            } else if (g > 0.0f && b == 1.0f) {
                MiningProperties.setColor(stack, (short)(g * 255.0f - Math.min(Math.abs(0.0f - g * 255.0f), 5.0f)), "colorGreen");
            }
        }
        int range = MiningProperties.getBeamRange(stack);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, RayTraceContext.FluidMode.NONE, range);
        if (world.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)player, stack, range).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((PlayerEntity)player, lookingAt, world, MiningProperties.getRange(stack));
        if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.FREEZING)) {
            for (BlockPos sourcePos : this.findSources(player.field_70170_p, coords)) {
                int delay = MiningProperties.getFreezeDelay(stack);
                if (delay != 0 && count % delay != 0) continue;
                this.spawnFreezeParticle((PlayerEntity)player, sourcePos, player.field_70170_p, stack);
            }
        }
        if (!world.field_72995_K) {
            int energy;
            int efficiency = 0;
            if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.EFFICIENCY_1)) {
                efficiency = UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier();
            }
            float hardness = MiningGadget.getHardness(coords, (PlayerEntity)player, efficiency);
            hardness = hardness * (float)MiningProperties.getRange(stack) * 1.0f;
            if ((hardness = (float)Math.floor(hardness)) == 0.0f) {
                hardness = 1.0f;
            }
            for (BlockPos coord : coords) {
                BlockState state = world.func_180495_p(coord);
                if (!(state.func_177230_c() instanceof RenderBlock)) {
                    if (!MiningGadget.canMineBlock(stack, world, (PlayerEntity)player, coord, state)) {
                        return;
                    }
                    List<Upgrade> gadgetUpgrades = UpgradeTools.getUpgrades(stack);
                    boolean placed = world.func_175656_a(coord, ((Block)ModBlocks.RENDER_BLOCK.get()).func_176223_P());
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.func_175625_s(coord);
                    if (!placed || te == null) {
                        return;
                    }
                    te.setRenderBlock(state);
                    te.setBreakType(MiningProperties.getBreakType(stack));
                    te.setGadgetUpgrades(gadgetUpgrades);
                    te.setGadgetFilters(MiningProperties.getFiltersAsList(stack));
                    te.setGadgetIsWhitelist(MiningProperties.getWhiteList(stack));
                    te.setPriorDurability((int)hardness + 1);
                    te.setOriginalDurability((int)hardness + 1);
                    te.setDurability((int)hardness, stack);
                    te.setPlayer((PlayerEntity)player);
                    te.setBlockAllowed();
                } else {
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.func_175625_s(coord);
                    if (te != null) {
                        int durability = te.getDurability();
                        if (--durability <= 0) {
                            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(MiningGadget.getEnergyCost(stack) * -1, false));
                            if (MiningProperties.getPrecisionMode(stack)) {
                                MiningProperties.setCanMine(stack, false);
                                player.func_184602_cy();
                            }
                        }
                        te.setDurability(durability, stack);
                    }
                }
                if (!stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("wildfirev")) continue;
                this.spawnFireParticle(coord, (ServerWorld)player.field_70170_p);
            }
            if (!UpgradeTools.containsActiveUpgrade(stack, Upgrade.LIGHT_PLACER)) {
                return;
            }
            Direction side = lookingAt.func_216354_b();
            boolean vertical = side.func_176740_k().func_200128_b();
            Direction up = vertical ? player.func_174811_aO() : Direction.UP;
            Direction right = vertical ? up.func_176746_e() : side.func_176735_f();
            BlockPos pos = MiningProperties.getRange(stack) == 1 ? lookingAt.func_216350_a().func_177967_a(side, 4) : lookingAt.func_216350_a().func_177972_a(side).func_177972_a(right);
            if (world.func_201696_r(pos) <= 7 && world.func_180495_p(pos).func_185904_a() == Material.field_151579_a && (energy = stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue()) > (Integer)Config.UPGRADECOST_LIGHT.get()) {
                world.func_175656_a(pos, ((Block)ModBlocks.MINERS_LIGHT.get()).func_176223_P());
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy((Integer)Config.UPGRADECOST_LIGHT.get() * -1, false));
            }
        }
    }

    public static int getEnergyCost(ItemStack stack) {
        int cost = (Integer)Config.MININGGADGET_BASECOST.get();
        List<Upgrade> upgrades = UpgradeTools.getActiveUpgrades(stack);
        if (upgrades.isEmpty()) {
            return cost;
        }
        return cost + upgrades.stream().mapToInt(Upgrade::getCostPerBlock).sum();
    }

    private static float getHardness(List<BlockPos> coords, PlayerEntity player, int efficiency) {
        EffectInstance miningFatigue;
        EffectInstance hasteEffect;
        float hardness = 0.0f;
        float toolSpeed = 8.0f;
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if ((hasteEffect = player.func_70660_b(Effects.field_76422_e)) != null) {
            int hasteLevel = hasteEffect.func_76458_c() + 1;
            toolSpeed += toolSpeed * ((float)hasteLevel * 20.0f / 100.0f);
        }
        if ((miningFatigue = player.func_70660_b(Effects.field_76419_f)) != null) {
            toolSpeed /= 3.0f;
        }
        World world = player.field_70170_p;
        for (BlockPos coord : coords) {
            RenderBlockTileEntity blockEntity;
            BlockState state = world.func_180495_p(coord);
            float temphardness = state.func_185887_b((IBlockReader)world, coord);
            if (state.func_177230_c() instanceof RenderBlock && (blockEntity = (RenderBlockTileEntity)world.func_175625_s(coord)) != null) {
                temphardness = blockEntity.getRenderBlock().func_185887_b((IBlockReader)world, coord);
            }
            hardness += temphardness * 30.0f / toolSpeed;
        }
        return hardness / (float)coords.size();
    }

    public static void applyUpgrade(ItemStack tool, UpgradeCard upgradeCard) {
        if (UpgradeTools.containsUpgrade(tool, upgradeCard.getUpgrade())) {
            return;
        }
        UpgradeTools.setUpgrade(tool, upgradeCard);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (worldIn.field_72995_K && this.laserLoopSound != null) {
            float volume = MiningProperties.getVolume(stack);
            if (volume != 0.0f && !this.laserLoopSound.func_147667_k()) {
                entityLiving.func_184185_a(OurSounds.LASER_END.getSound(), volume * 0.5f, 1.0f);
            }
            this.laserLoopSound = null;
        }
        if (entityLiving instanceof PlayerEntity) {
            entityLiving.func_184602_cy();
        }
        if (!worldIn.field_72995_K) {
            MiningProperties.setCanMine(stack, true);
        }
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof MiningGadget) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof MiningGadget)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public static boolean isHolding(PlayerEntity entity) {
        return MiningGadget.getGadget(entity).func_77973_b() instanceof MiningGadget;
    }
}

