/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.blocks;

import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModificationTable
extends Block {
    public static DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)2.0, (double)11.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)9.0), Block.func_208617_a((double)0.0, (double)10.0, (double)11.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)10.0), Block.func_208617_a((double)13.0, (double)12.0, (double)2.0, (double)14.0, (double)13.0, (double)8.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.func_208617_a((double)0.0, (double)11.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)7.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0), Block.func_208617_a((double)6.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)8.0, (double)12.0, (double)13.0, (double)14.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.func_208617_a((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)1.0, (double)10.0, (double)7.0, (double)15.0, (double)11.0, (double)15.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)5.0), Block.func_208617_a((double)0.0, (double)11.0, (double)6.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)2.0, (double)12.0, (double)8.0, (double)3.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.func_208617_a((double)12.0, (double)11.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)9.0, (double)11.0, (double)15.0), Block.func_208617_a((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0), Block.func_208617_a((double)2.0, (double)12.0, (double)2.0, (double)8.0, (double)13.0, (double)3.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public ModificationTable() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case EAST: {
                return SHAPE_E;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
        }
        throw new IllegalStateException("Invalid State");
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ModificationTableTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof INamedContainerProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != this) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null) {
                LazyOptional cap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                cap.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

