/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;

public class RenderUtils {
    public static void renderWallsWithLines(class_2338 posStart, class_2338 posEnd, class_243 cameraPos, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        class_1297 entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.method_10263(), posEnd.method_10263());
        int boxMinZ = Math.min(posStart.method_10260(), posEnd.method_10260());
        int boxMaxX = Math.max(posStart.method_10263(), posEnd.method_10263());
        int boxMaxZ = Math.max(posStart.method_10260(), posEnd.method_10260());
        int centerX = (int)Math.floor(entity.method_23317());
        int centerZ = (int)Math.floor(entity.method_23321());
        int maxDist = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.method_10264(), posEnd.method_10264());
        double maxY = Math.max(posStart.method_10264(), posEnd.method_10264()) + 1;
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
    }

    public static void renderWallWithLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.field_1352;
                cy = cameraPos.field_1351;
                cz = cameraPos.field_1350;
                bufferQuads.method_22912(minX - cx, maxY - cy, minZ - cz).method_22915(color.r, color.g, color.b, color.a).method_1344();
                bufferQuads.method_22912(minX - cx, minY - cy, minZ - cz).method_22915(color.r, color.g, color.b, color.a).method_1344();
                bufferQuads.method_22912(maxX - cx, minY - cy, maxZ - cz).method_22915(color.r, color.g, color.b, color.a).method_1344();
                bufferQuads.method_22912(maxX - cx, maxY - cy, maxZ - cz).method_22915(color.r, color.g, color.b, color.a).method_1344();
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? RenderUtils.roundUp(minY, lineIntervalV) : minY;
                    while (lineY <= maxY) {
                        bufferLines.method_22912(minX - cx, lineY - cy, minZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                        bufferLines.method_22912(maxX - cx, lineY - cy, maxZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (minX != maxX) break block5;
                double d = lineZ = alignLinesToModulo ? RenderUtils.roundUp(minZ, lineIntervalH) : minZ;
                while (lineZ <= maxZ) {
                    bufferLines.method_22912(minX - cx, minY - cy, lineZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                    bufferLines.method_22912(minX - cx, maxY - cy, lineZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (minZ != maxZ) break block4;
            double d = lineX = alignLinesToModulo ? RenderUtils.roundUp(minX, lineIntervalH) : minX;
            while (lineX <= maxX) {
                bufferLines.method_22912(lineX - cx, minY - cy, minZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                bufferLines.method_22912(lineX - cx, maxY - cy, minZ - cz).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                lineX += lineIntervalH;
            }
        }
    }

    public static void drawBlockSpaceSideBatchedQuads(long posLong, class_2350 side, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)posLong);
        int y = class_2338.method_10071((long)posLong);
        int z = class_2338.method_10083((long)posLong);
        double offsetX = (double)x - cameraPos.field_1352;
        double offsetY = (double)y - cameraPos.field_1351;
        double offsetZ = (double)z - cameraPos.field_1350;
        double minX = offsetX - expand;
        double minY = offsetY - expand;
        double minZ = offsetZ - expand;
        double maxX = offsetX + expand + 1.0;
        double maxY = offsetY + expand + 1.0;
        double maxZ = offsetZ + expand + 1.0;
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }

    public static void renderCircleBlockPositions(LongOpenHashSet positions, class_2350[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : sides) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = class_2338.method_10061((long)adjPosLong);
                    int adjY = class_2338.method_10071((long)adjPosLong);
                    int adjZ = class_2338.method_10083((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositions(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderQuads(Collection<SideQuad> quads, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuad(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuad(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        RenderUtils.renderInsetQuad(minPos.method_10263(), minPos.method_10264(), minPos.method_10260(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(long minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)minPos);
        int y = class_2338.method_10071((long)minPos);
        int z = class_2338.method_10083((long)minPos);
        RenderUtils.renderInsetQuad(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(int x, int y, int z, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        double minX = (double)x - cameraPos.field_1352;
        double minY = (double)y - cameraPos.field_1351;
        double minZ = (double)z - cameraPos.field_1350;
        double maxX = minX;
        double maxY = minY;
        double maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (double)width;
            maxY += (double)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (double)height;
            maxZ += (double)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (double)width;
            maxZ += (double)height;
        }
        switch (side) {
            case field_11039: {
                buffer.method_22912(minX += inset, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX += 1.0 - inset, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(minX, minY, minZ += inset).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ += 1.0 - inset).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11033: {
                buffer.method_22912(minX, minY += inset, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY += 1.0 - inset, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }

    public static void renderBiomeBorderLines(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        double minX = (double)minPos.method_10263() - cameraPos.field_1352;
        double minY = (double)minPos.method_10264() - cameraPos.field_1351;
        double minZ = (double)minPos.method_10260() - cameraPos.field_1350;
        switch (side) {
            case field_11039: {
                minX += inset;
                break;
            }
            case field_11034: {
                minX += 1.0 - inset;
                break;
            }
            case field_11043: {
                minZ += inset;
                break;
            }
            case field_11035: {
                minZ += 1.0 - inset;
                break;
            }
            case field_11033: {
                minY += inset;
                break;
            }
            case field_11036: {
                minY += 1.0 - inset;
            }
        }
        double maxX = minX;
        double maxY = minY;
        double maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (double)width;
            maxY += (double)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (double)height;
            maxZ += (double)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (double)width;
            maxZ += (double)height;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            for (double z = minZ; z < maxZ + 0.5; z += 1.0) {
                buffer.method_22912(minX, minY, z).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                buffer.method_22912(maxX, maxY, z).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            }
        } else {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            for (double y = minY; y < maxY + 0.5; y += 1.0) {
                buffer.method_22912(minX, y, minZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
                buffer.method_22912(maxX, y, maxZ).method_22915(color.r, color.g, color.b, 1.0f).method_1344();
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }
}

