/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.RenderContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class OverlayRenderer {
    private static long loginTime;
    private static boolean canRender;

    public static void resetRenderTimeout() {
        canRender = false;
        loginTime = System.currentTimeMillis();
    }

    public static void renderOverlays(class_4587 matrixStack, Matrix4f projMatrix, class_310 mc) {
        class_1297 entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return;
        }
        if (!canRender) {
            if (System.currentTimeMillis() - loginTime >= 5000L || entity.method_23317() != 8.5 || entity.method_23318() != 65.0 || entity.method_23321() != 8.5) {
                canRender = true;
            } else {
                return;
            }
        }
        if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue()) {
            mc.method_16011().method_15400(() -> "BeaconRangeHeldItem");
            OverlayRenderer.renderBeaconBoxForPlayerIfHoldingItem(entity, mc);
            mc.method_16011().method_15407();
        }
        RenderContainer.INSTANCE.render(entity, matrixStack, projMatrix, mc);
    }

    public static void renderBeaconBoxForPlayerIfHoldingItem(class_1297 entity, class_310 mc) {
        class_1792 item = mc.field_1724.method_6047().method_7909();
        if (item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10327) {
            OverlayRenderer.renderBeaconBoxForPlayer(entity, mc);
            return;
        }
        item = mc.field_1724.method_6047().method_7909();
        if (item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10327) {
            OverlayRenderer.renderBeaconBoxForPlayer(entity, mc);
        }
    }

    private static void renderBeaconBoxForPlayer(class_1297 entity, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = Math.floor(entity.method_23317()) - cameraPos.field_1352;
        double y = Math.floor(entity.method_23318()) - cameraPos.field_1351;
        double z = Math.floor(entity.method_23321()) - cameraPos.field_1350;
        int level = mc.field_1724.method_5715() ? Math.min(4, mc.field_1724.method_31548().field_7545 + 1) : 4;
        double range = level * 10 + 10;
        double minX = x - range;
        double minY = y - range;
        double minZ = z - range;
        double maxX = x + range + 1.0;
        double maxY = y + 4.0;
        double maxZ = z + range + 1.0;
        Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)0.3f), (class_287)buffer);
        tessellator.method_1350();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (class_287)buffer);
        tessellator.method_1350();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

