/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(Chunk chunk, World world) {
        IColony colony;
        int closeColony;
        int distanceToDelete = (Integer)MineColonies.getConfig().getServer().maxColonySize.get() * 16 * 2 * 5;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            }
        }
        if ((closeColony = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0).intValue()) != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (RegistryKey<World>)world.func_234923_W_())) != null) {
            colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
        }
    }

    public static void unloadChunk(Chunk chunk, World world) {
        IColony colony;
        int closeColony = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (RegistryKey<World>)world.func_234923_W_())) != null) {
            colony.removeLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b));
        }
    }

    public static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        }
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center) {
        int range = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        ChunkDataHelper.staticClaimInRange(id, add, center, range, world, false);
    }

    public static void claimBuildingChunks(IColony colony, boolean add, BlockPos center, int range) {
        ChunkDataHelper.buildingClaimInRange(colony, add, range, center, false);
    }

    public static boolean canClaimChunksInRange(World w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                Chunk chunk = w.func_212866_a_(i, j);
                IColonyTagCapability colonyCap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
                if (colonyCap == null) {
                    return true;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void buildingClaimInRange(IColony colony, boolean add, int range, BlockPos center, boolean force) {
        World world = colony.getWorld();
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().func_177958_n(), 0, colony.getCenter().func_177952_p());
        int chunkX = center.func_177958_n() >> 4;
        int chunkZ = center.func_177952_p() >> 4;
        int maxColonySize = (Integer)MineColonies.getConfig().getServer().maxColonySize.get();
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (!force && maxColonySize != 0 && pos.func_177951_i((Vector3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.func_177958_n() + " Z:" + pos.func_177952_p() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (!ChunkDataHelper.tryClaimBuilding(world, pos, add, colony, center, chunkManager)) continue;
            }
        }
        if (add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            MessageUtils.format("com.minecolonies.coremod.colonysizechange", range, building.getSchematicName()).sendTo(colony).forManagers();
        }
    }

    public static void staticClaimInRange(int colonyId, boolean add, BlockPos center, int range, World world, boolean forceOwnerChange) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.tryClaim(world, center, add, colonyId, chunkManager, forceOwnerChange);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                if (i == chunkX && j == chunkZ || i < chunkX - 5 || j < chunkZ - 5 || i > chunkX + 5 || j > chunkZ + 5) continue;
                ChunkDataHelper.tryClaim(world, new BlockPos(i * 16, 0, j * 16), add, colonyId, chunkManager, forceOwnerChange);
            }
        }
    }

    public static boolean tryClaim(World world, BlockPos chunkBlockPos, boolean add, int id, IChunkmanagerCapability chunkManager, boolean forceOwnerChange) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, chunkBlockPos)) {
            ChunkLoadStorage newStorage = new ChunkLoadStorage(id, new ChunkPos(chunkBlockPos).func_201841_a(), add, world.func_234923_W_().func_240901_a_(), forceOwnerChange);
            chunkManager.addChunkStorage(SectionPos.func_218159_a((int)chunkBlockPos.func_177958_n()), SectionPos.func_218159_a((int)chunkBlockPos.func_177958_n()), newStorage);
            return false;
        }
        Chunk chunk = (Chunk)world.func_217349_x(chunkBlockPos);
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addColony(id, chunk);
            if (forceOwnerChange) {
                cap.setOwningColony(id, chunk);
                IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (RegistryKey<World>)world.func_234923_W_());
                if (colony != null) {
                    colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
                }
            }
        } else {
            cap.removeColony(id, chunk);
        }
        Network.getNetwork().sendToTrackingChunk(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b), chunk);
        return true;
    }

    public static boolean tryClaimBuilding(World world, BlockPos chunkBlockPos, boolean add, IColony colony, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, chunkBlockPos)) {
            ChunkLoadStorage newStorage = new ChunkLoadStorage(colony.getID(), new ChunkPos(chunkBlockPos).func_201841_a(), world.func_234923_W_().func_240901_a_(), buildingPos, add);
            chunkManager.addChunkStorage(SectionPos.func_218159_a((int)chunkBlockPos.func_177958_n()), SectionPos.func_218159_a((int)chunkBlockPos.func_177952_p()), newStorage);
            return false;
        }
        Chunk chunk = world.func_175726_f(chunkBlockPos);
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(colony.getID(), buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(colony.getID(), buildingPos, chunk);
        }
        Network.getNetwork().sendToTrackingChunk(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b), chunk);
        return true;
    }
}

