/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ResearchResearchRequirement
implements IResearchRequirement {
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private final ResourceLocation researchId;
    private final TranslationTextComponent researchName;

    public ResearchResearchRequirement(ResourceLocation researchId) {
        this.researchId = researchId;
        this.researchName = new TranslationTextComponent("com." + researchId.func_110624_b() + ".research." + researchId.func_110623_a().replaceAll("[ /]", ".") + ".name");
    }

    public ResearchResearchRequirement(ResourceLocation researchId, TranslationTextComponent researchName) {
        this.researchId = researchId;
        this.researchName = researchName;
    }

    public ResearchResearchRequirement(CompoundNBT nbt) {
        this.researchId = new ResourceLocation(nbt.func_74779_i(TAG_ID));
        this.researchName = new TranslationTextComponent(nbt.func_74779_i(TAG_NAME));
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.getResearchManager().getResearchTree().hasCompletedResearch(this.researchId);
    }

    @Override
    public TranslationTextComponent getDesc() {
        return new TranslationTextComponent("com.minecolonies.coremod.research.requirement.research", new Object[]{this.researchName});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return ModResearchRequirements.researchResearchRequirement;
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(TAG_ID, this.researchId.toString());
        nbt.func_74778_a(TAG_NAME, this.researchName.func_150268_i());
        return nbt;
    }
}

